% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers-cv.R
\name{tidy.mc_cv}
\alias{tidy.mc_cv}
\alias{tidy.wb_cv}
\alias{tidy.sb_cv}
\alias{augment.mc_cv}
\alias{augment.wb_cv}
\alias{augment.sb_cv}
\title{Tidy an cv object}
\usage{
\method{tidy}{mc_cv}(x, format = c("wide", "long"), ...)

\method{tidy}{wb_cv}(x, format = c("wide", "long"), ...)

\method{tidy}{sb_cv}(x, format = c("wide", "long"), ...)

\method{augment}{mc_cv}(x, format = c("wide", "long"), ...)

\method{augment}{wb_cv}(x, format = c("wide", "long"), ...)

\method{augment}{sb_cv}(x, format = c("wide", "long"), ...)
}
\arguments{
\item{x}{An \code{cv} object}

\item{format}{Long or wide format}

\item{...}{Additional arguments. Not used.}
}
\value{
A A \code{\link[tibble:tibble]{tibble::tibble()}}

\itemize{
\item sig The significance level.
\item name The name of the series (when format is "long")
\item crit The critical value (when format is "long")
}
}
\description{
Tidy an cv object
}
\examples{
\dontrun{
mc <- mc_cv(100)

# Get the critical values
tidy(mc)

# Get the critical value sequences
augment(mc)

}
}
