% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{predict.hill}
\alias{predict.hill}
\title{Predict the adaptive Survival or Quantile function}
\usage{
\method{predict}{hill}(object, pgrid = 1:(length(object$xsort) -
  1)/length(object$xsort), xgrid = object$xsort, type = "quantile",
  threshold.rank = 0, threshold = 0, ...)
}
\arguments{
\item{object}{output  object of the function hill.}

\item{pgrid}{used if type = "quantile", a vector of probabilities.}

\item{xgrid}{used if type = "survival", a vector of values.}

\item{type}{either "quantile" or "survival".}

\item{threshold.rank}{the rank value for the hill output of the threshold, with default value 0.}

\item{threshold}{the value of threshold, with default value 0.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function provide the quantile assiociated to the adaptive model for the probability grid (transformed to -log(1-p) in the output) if type = "quantile". And the survival function assiociated to the adaptive model for the quantile grid if type = "survival".
}
\description{
Give the adaptive survival function or quantile function
}
\details{
If type = "quantile", \eqn{pgrid} must be between 0 and 1. If type = "survival", \eqn{xgrid} must be in the domain of the data from the \code{hill} function.
}
\examples{
x <- abs(rcauchy(100))
hh <- hill(x)
#example for a fixed value of threshold
predict(hh, threshold = 3)
#example for a fixed rank value of threshold
predict(hh, threshold.rank = 30)

}
\seealso{
\code{\link{hill}}
}

