% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_gamma_pois}
\alias{sens_gamma_pois}
\title{Adjust Gamma-Poisson Distribution Parameters for Sensitivity Analyses}
\usage{
sens_gamma_pois(lambda, theta, sd_mult = 2)
}
\arguments{
\item{lambda}{A non-negative numeric vector of means.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture
models (student, gamma-Poisson and beta-binomial).}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) the standard deviation of the Negative Binomial
distribution. This function does not currently have the option to reduce the
standard deviation.
}
\examples{
sens_gamma_pois(10, 0.1, 2)
}
\seealso{
Other sens_dist: 
\code{\link{sens_beta}()},
\code{\link{sens_exp}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois_zi}()},
\code{\link{sens_lnorm}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_norm}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
