% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta-negative-binomial-distribution.R
\name{BetaNegBinom}
\alias{BetaNegBinom}
\alias{dbnbinom}
\alias{pbnbinom}
\alias{rbnbinom}
\title{Beta-Negative Binomial distribution}
\usage{
dbnbinom(x, size, alpha = 1, beta = 1, log = FALSE)

pbnbinom(q, size, alpha = 1, beta = 1, lower.tail = TRUE, log.p = FALSE)

rbnbinom(n, size, alpha = 1, beta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{alpha, beta}{non-negative parameters of the beta distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the Beta-binomial distribution.
}
\details{
Probability mass function
\deqn{
f(x) = \frac{\Gamma(r+k)}{k! \Gamma(r)}
       \frac{\mathrm{B}(\alpha+r, \beta+k)}{\mathrm{B}(\alpha, \beta)}
}{
f(x) = gamma(r+k)/(k! gamma(r)) * beta(alpha+r, beta+k)/beta(alpha, beta)
}
}
\examples{

x <- rbnbinom(1e5, 1000, 5, 13)
xx <- 0:1e5
hist(x, 100, freq = FALSE)
lines(xx-0.5, dbnbinom(xx, 1000, 5, 13), col = "red")
hist(pbnbinom(x, 1000, 5, 13))
plot(ecdf(x))
lines(xx, pbnbinom(xx, 1000, 5, 13), col = "red", lwd = 2)

}
\seealso{
\code{\link[stats]{Beta}}, \code{\link[stats]{NegBinomial}}
}
\keyword{distribution}

