% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-split.R
\name{splitStratify}
\alias{splitStratify}
\title{Split by Stratified Sampling}
\usage{
splitStratify(object, percent.include = 67, colBy = NULL, bin = rep(FALSE,
  length(colBy)), breaks = rep(list(NA), length(colBy)), ...)
}
\arguments{
\item{object}{An \code{ExprsArray} object to split.}

\item{percent.include}{Specifies the percent of the total number
of subjects to include in the training set.}

\item{colBy}{Specifies a vector of column names by which to stratify in
addition to class labels annotation. If \code{colBy = NULL}, random
sampling will occur across the class label annotation only.
For \code{splitStratify} only.}

\item{bin}{A logical vector indicating whether to bin the respective
\code{colBy} column using \code{cut} (e.g., \code{bin = c(FALSE, TRUE)}).
For \code{splitStratify} only.}

\item{breaks}{A list. Each element of the list should correspond to a
\code{breaks} argument passed to \code{cut} for the respective
\code{colBy} column. Set an element to \code{NA} when not binning
that \code{colBy}. For \code{splitStratify} only.}

\item{...}{For \code{splitSample}: additional arguments passed
along to \code{\link{sample}}. For \code{splitStratify}: additional
arguments passed along to \code{\link{cut}}.}
}
\value{
Returns a list of two \code{ExprsArray} objects.
}
\description{
\code{splitStratify} builds a training and validation set through a stratified
 random sampling process. This function utilizes the \code{strata} function from the
 sampling package as well as the \code{cut} function from the base package. The latter
 function provides a means by which to bin continuous data prior to stratified random
 sampling. We refer the user to the parameter descriptions to learn the specifics of
 how to apply binning, although the user might find it easier to instead bin
 annotations beforehand. When applied to an \code{ExprsMulti} object, this function
 stratifies subjects across all classes found in that dataset.
}
