% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3-exprso.R
\name{build}
\alias{build}
\title{Build Models}
\description{
The \code{exprso} package includes these build modules:

- \code{\link{buildNB}}

- \code{\link{buildLDA}}

- \code{\link{buildSVM}}

- \code{\link{buildANN}}

- \code{\link{buildRF}}

- \code{\link{buildDNN}}
}
\details{
In the case of multi-class classification, each \code{build} module can
 harness the \code{\link{doMulti}} function to perform "1 vs. all" classifier
 construction. In the setting of four class labels, a single \code{build} call
 will return four classifiers that work in concert to make a single prediction
 of an unlabelled subject. For building multiple classifiers across a vast
 parameter space in a high-throughput manner, see \code{\link{pl}}.

Like \code{\link{fs}} methods, \code{build} methods have a \code{top} argument
 which allows the user to specify which features to feed INTO the model
 build. This effectively provides the user with one last opportunity to subset
 the feature space based on prior feature selection or dimension reduction.
 For all build methods, \code{@preFilter} and \code{@reductionModel} will
 get passed along to the resultant \code{ExprsModel} object, again ensuring
 that any test or validation sets will undergo the same feature selection and
 dimension reduction in the appropriate steps when deploying the model.
 Set \code{top = 0} to pass all features through a \code{build} method.
}
