% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-var.R
\name{add_var_random_cat}
\alias{add_var_random_cat}
\title{Add a random categorical variable to dataset}
\usage{
add_var_random_cat(
  data,
  name = "random_cat",
  cat = LETTERS[1:6],
  prob,
  overwrite = TRUE,
  seed
)
}
\arguments{
\item{data}{A dataset}

\item{name}{Name of new variable (as string)}

\item{cat}{Vector of categories}

\item{prob}{Vector of probabilities}

\item{overwrite}{Can new random variable overwrite an existing variable in dataset?}

\item{seed}{Seed for random number generation (integer)}
}
\value{
Dataset containing new random variable
}
\description{
Add a random categorical variable to dataset
}
\examples{
library(magrittr)
iris \%>\% add_var_random_cat() \%>\% head()
iris \%>\% add_var_random_cat(name = "my_cat") \%>\% head()
iris \%>\% add_var_random_cat(cat = c("Version A", "Version B")) \%>\% head()
iris \%>\% add_var_random_cat(cat = c(1,2,3,4,5)) \%>\% head()
}
