% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_predictions}
\alias{get_predictions}
\title{Get the predicted values}
\usage{
get_predictions(model, model_name, x_range)
}
\arguments{
\item{model}{An \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_Wisle}} object, i.e. a list returned
by the \code{\link{expirest_osle}()} or by the
\code{\link{expirest_wisle}()} function.}

\item{model_name}{A character string representing the acronym that specifies
which model, based on the ANCOVA analysis, suits best.}

\item{x_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the time variable to be plotted.}
}
\value{
A data frame with the columns named after the \code{batch_vbl}, the
\code{time_vbl} and the \code{response_vbl} (see function descriptions of
\code{\link{plot_expirest_osle}()} or \code{\link{plot_expirest_wisle}()})
and further two columns named \code{LL} and \code{UL} which represent the
lower or the upper confidence or prediction interval limits, respectively.
}
\description{
The function \code{get_predictions()} makes the predictions to be shown
on the graphs prepared by the function \code{\link{plot_expirest_osle}()}
or \code{\link{plot_expirest_wisle}()}.
}
\details{
The function \code{get_predictions()} prepares a data frame that
contains the predicted values .
}
\seealso{
\code{\link{plot_expirest_osle}}, \code{\link{plot_expirest_wisle}}.
}
\keyword{internal}
