% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.surv.R
\name{make.surv}
\alias{make.surv}
\title{Engine for Probabilistic Sensitivity Analysis on the survival curves}
\usage{
make.surv(fit, mod = 1, t = NULL, newdata = NULL, nsim = 1, ...)
}
\arguments{
\item{fit}{the result of the call to the \code{fit.models} function,
containing the model fitting (and other relevant information)}

\item{mod}{the index of the model. Default value is 1, but the user can
choose which model fit to visualise, if the call to fit.models has a vector
argument for distr (so many models are fitted & stored in the same object)}

\item{t}{the time vector to be used for the estimation of the survival curve}

\item{newdata}{a list (of lists), specifiying the values of the covariates
at which the computation is performed. For example
\code{list(list(arm=0),list(arm=1))} will create two survival curves, one
obtained by setting the covariate \code{arm} to the value 0 and the other by
setting it to the value 1. In line with \code{flexsurv} notation, the user
needs to either specify the value for \emph{all} the covariates or for none (in
which case, \code{newdata=NULL}, which is the default). If some value is
specified and at least one of the covariates is continuous, then a single
survival curve will be computed in correspondence of the average values of
all the covariates (including the factors, which in this case are expanded
into indicators).}

\item{nsim}{The number of simulations from the distribution of the survival
curves. Default at \code{nsim=1}, in which case uses the point estimate for
the relevant distributional parameters and computes the resulting survival
curve}

\item{...}{Additional options}
}
\value{
A list with survival times for the fitted models
}
\description{
Creates the survival curves for the fitted model(s) - Original code from \code{survHE}
}
\references{
\insertRef{Baio.2020}{expertsurv}
}
\seealso{
\code{psa.plot} (for example)
}
\author{
Gianluca Baio
}
\keyword{Bootstrap}
\keyword{Probabilistic}
\keyword{Survival}
\keyword{analysis}
\keyword{models}
\keyword{sensitivity}
