% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kr20}
\alias{kr20}
\title{Calculate KR-20 reliability coefficient}
\usage{
kr20(m)
}
\arguments{
\item{m}{A data.frame or matrix where rows are subjects and columns are
dichotomously scored (0/1) items.}
}
\value{
A numeric value for the KR-20 coefficient, or NA_real_ if
calculation is not possible.
}
\description{
Calculates the Kuder-Richardson 20 (KR-20) reliability coefficient
for a data.frame or matrix of dichotomous (0/1) items.
}
\examples{
item_matrix <- data.frame(
  m1 = c(1, 1, 0, 1),
  m2 = c(1, 0, 1, 1),
  m3 = c(0, 1, 0, 0)
)
kr20(item_matrix)
}
