% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EkNNval.R
\name{EkNNval}
\alias{EkNNval}
\title{Classification of a test set by the EkNN classifier}
\usage{
EkNNval(xtrain, ytrain, xtst, K, ytst = NULL, param = NULL)
}
\arguments{
\item{xtrain}{Matrix of size ntrain x d, containing the values of the d attributes for the
training data.}

\item{ytrain}{Vector of class labels for the training data (of length ntrain). May
be a factor, or a vector of integers.}

\item{xtst}{Matrix of size ntst x d, containing the values of the d attributes for the
test data.}

\item{K}{Number of neighbors.}

\item{ytst}{Vector of class labels for the test data (optional). May
be a factor, or a vector of integers.}

\item{param}{Parameters, as returned by \code{\link{EkNNfit}}.}
}
\value{
A list with three elements:
  \describe{
  \item{m}{Predicted mass functions for the test data. The first M columns correspond
  to the mass assigned to each class. The last column corresponds to the mass
  assigned to the whole set of classes.}
  \item{ypred}{Predicted class labels for the test data.}
  \item{err}{Test error rate.}
 }
}
\description{
\code{EkNNval} classifies instances in a test set using the EkNN classifier.
}
\details{
If class labels for the test set are provided, the test error rate is also returned.
If parameters are not supplied, they are given default values by \code{\link{EkNNinit}}.
}
\examples{
## Iris dataset
data(iris)
train<-sample(150,100)
xtrain<-iris[train,1:4]
ytrain<-iris[train,5]
xtst<-iris[-train,1:4]
ytst<-iris[-train,5]
K<-5
fit<-EkNNfit(xtrain,ytrain,K)
test<-EkNNval(xtrain,ytrain,xtst,K,ytst,fit$param)
}
\author{
Thierry Denoeux.
}
\references{
T. Denoeux. A k-nearest neighbor classification rule based on Dempster-Shafer
theory. IEEE Transactions on Systems, Man and Cybernetics, 25(05):804--813, 1995.

L. M. Zouhal and T. Denoeux. An evidence-theoretic k-NN rule with parameter
optimization. IEEE Transactions on Systems, Man and Cybernetics Part C,
28(2):263--271,1998.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{EkNNinit}}, \code{\link{EkNNfit}}
}

