% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_toc.R
\name{get_eurostat_toc}
\alias{get_eurostat_toc}
\title{Download Table of Contents of Eurostat Data Sets}
\usage{
get_eurostat_toc()
}
\value{
A tibble with eight columns
   \itemize{
     \item{title}{The name of dataset of theme}
     \item{code}{The codename of dataset of theme, will be used by the eurostat and get_eurostat_raw functions.}
     \item{type}{Is it a dataset, folder or table.}
     \item{last.update.of.data, last.table.structure.change, data.start, data.end}{Dates.}
   }
}
\description{
Download table of contents (TOC) of eurostat datasets.
}
\details{
The TOC is downloaded from \url{http://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing?sort=1&file=table_of_contents_en.txt}. The values in column 'code' should be used to download a selected dataset.
}
\examples{
\dontrun{tmp <- get_eurostat_toc(); head(tmp)}
}
\author{
Przemyslaw Biecek and Leo Lahti \email{ropengov-forum@googlegroups.com}
}
\references{
See citation("eurostat").
}
\seealso{
\code{\link{get_eurostat}}, \code{\link{search_eurostat}}.
}
\keyword{database}
\keyword{utilities}

