% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations_by_id.R
\name{epmc_annotations_by_id}
\alias{epmc_annotations_by_id}
\title{Get annotations by article}
\usage{
epmc_annotations_by_id(ids = NULL)
}
\arguments{
\item{ids, }{character vector with publication identifiers
following the structure "source:ext_id", e.g. `"MED:28585529"`}
}
\value{
returns text-mined annotations in a tidy format with the following
variables

\describe{
  \item{source}{Publication data source}
  \item{ext_id}{Article Identifier}
  \item{pmcid}{PMCID that locates full-text in Pubmed Central}
  \item{prefix}{Text snipped found before the annotation}
  \item{exact}{Annotated entity}
  \item{postfix}{Text snipped found after the annotation}
  \item{name}{Targeted entity}
  \item{uri}{Uniform link dictionary entry for targeted entity}
  \item{id}{URL to full-text occurence of the annotation}
  \item{type}{Type of annotation like Chemicals}
  \item{section}{Article section mentioning the annotation like Methods}
  \item{provider}{Annotation data provider}
  \item{subtype}{Sub-data provider}
}
}
\description{
Retrieve text-mined annotations contained in abstracts and open access
full-text articles.
}
\examples{
\dontrun{
  annotations_by_id("MED:28585529")
  # multiple ids
  annotations_by_id(c("MED:28585529", "PMC:PMC1664601"))
}
}
