% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{small_metrics}
\alias{small_metrics}
\title{Small Sample Metrics}
\usage{
small_metrics(
  D,
  prm,
  est = c("same", "me", "mle"),
  obs = c(20, 50, 100),
  sam = 10000,
  seed = 1,
  ...
)
}
\arguments{
\item{D}{A subclass of \code{Distribution}. The distribution family of interest.}

\item{prm}{A list containing three elements (name, pos, val). See Details.}

\item{est}{character. The estimator of interest. Can be a vector.}

\item{obs}{numeric. The size of each sample. Can be a vector.}

\item{sam}{numeric. The number of Monte Carlo samples used to estimate the
metrics.}

\item{seed}{numeric. Passed to \code{set.seed()} for reproducibility.}

\item{...}{extra arguments.}
}
\value{
For the small sample, a data.frame with columns named "Parameter",
"Observations", "Estimator", "Metric", and "Value". For the large sample, a
data.frame with columns "Row", "Col", "Parameter", "Estimator", and "Value".
}
\description{
This function performs Monte Carlo simulations to estimate the main metrics
(bias, variance, and RMSE) characterizing the small sample behavior of an
estimator. The function evaluates the metrics as a function of a single
parameter, keeping the other ones constant. See Details.
}
\details{
The distribution \code{D} is used to specify an initial distribution. The list
\code{prm} contains details concerning a single parameter that is allowed to
change values. The quantity of interest is evaluated as a function of this
parameter.

Specifically, \code{prm} includes three elements named "name", "pos", and "val".
The first two elements determine the exact parameter that changes, while the
third one is a numeric vector holding the values it takes. For example,
in the case of the Multivariate Gamma distribution,
\code{D <- MGamma(shape = c(1, 2), scale = 3)} and
\code{prm <- list(name = "shape", pos = 2, val = seq(1, 1.5, by = 0.1))}
means that the evaluation will be performed for the MGamma distributions with
shape parameters \verb{(1, 1)}, \verb{(1, 1.1)}, ..., \verb{(1, 1.5)} and scale \code{3}. Notice
that the initial shape parameter \code{2} in \code{D} is not utilized in the function.
}
\examples{
\donttest{
D <- distr::Beta(shape1 = 1, shape2 = 2)

prm <- list(name = "shape1",
            pos = NULL,
            val = seq(0.5, 2, by = 0.5))

x <- small_metrics(D, prm,
                   est = c("mle", "me", "same"),
                   obs = c(20, 50),
                   sam = 1e2,
                   seed = 1)

plot_small_metrics(x)
}
}
\seealso{
\link{plot_small_metrics} \link{large_metrics}, \link{plot_large_metrics}
}
