% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muestra.R
\name{muestra}
\alias{muestra}
\title{Tamaño de la muestra.}
\usage{
muestra(poblacion = c("normal","dicotomica"),
               error_estimacion = NULL,
               confianza = 0.95,
               irrestricto = FALSE)
}
\arguments{
\item{poblacion}{Texto, si \code{poblacion = "normal"} (por defecto), calcula el tamaño muestral que permita estimar la media de una población normal. Si \code{poblacion = "dicotomica"}, para estimar la proporción p de una población.}

\item{error_estimacion}{Es un valor que establece el error de estimación. Es la semiamplitud (mitad de la precisión) del intervalo de confianza. Esta aproximación solo es válida en distribuciones simétricas (normal o t-student).}

\item{confianza}{Es un valor entre 0 y 1 que indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento).}

\item{irrestricto}{Es un valor lógico que indica si se considera un muestreo aleatorio simple (por defecto, \code{irrestricto = FALSE}) o sin reemplazamiento (\code{irrestricto = TRUE}).}
}
\value{
Devuelve el tamaño de la muesta en un objeto de tipo \code{data.frame}.
}
\description{
Calcula el tamaño muestral para estimar la media de una población normal o la proporcion p de una población.

\if{html}{\figure{qrmuestra1.png}{options: width="25\%" alt="Figure: qrmuestra1.png"}}
\if{latex}{\figure{qrmuestra1.png}{options: scale=.25}}

\if{html}{\figure{qrmuestra2.png}{options: width="25\%" alt="Figure: qrmuestra2.png"}}
\if{latex}{\figure{qrmuestra2.png}{options: scale=.25}}
}
\details{
(1) El tamaño muestral para estimar la media poblacional se obtiene a partir de la siguiente expresión:

\if{html}{\figure{tamanomedia.png}{options: width="30\%" alt="Figure: tamanomedia.png"}}
\if{latex}{\figure{tamanomedia.png}{options: scale=.3}}

y si el muestreo es irrestricto:

\if{html}{\figure{tamanomediairrestricto.png}{options: width="60\%" alt="tamanomediairrestricto.png"}}
\if{latex}{\figure{tamanomediairrestricto.png}{options: scale=.6}}

Nota: si la varianza poblacional no es conocida puede estimarse a través de la varianza (o cuasi-varianza) muestral.

(2) El tamaño muestral para estimar la proporción de una característica se obtiene a partir de la expresión:

\if{html}{\figure{tamanoproporcion.png}{options: width="35\%" alt="Figure: tamanoproporcion.png"}}
\if{latex}{\figure{tamanoproporcion.png}{options: scale=.35}}

y si el muestreo es irrectricto:

\if{html}{\figure{tamanoproporcionirrestricto.png}{options: width="65\%" alt="Figure: tamanoproporcionirrestricto.png"}}
\if{latex}{\figure{tamanoproporcionirrestricto.png}{options: scale=.65}}

Nota: puede estimarse la proporción poblacional por la proporción muestral o, en caso
de no disponer de información, suponer el caso más desfavorable: p=q=0.5
}
\note{
En el caso del tamaño muestral para la media: si la varianza poblacional no es conocida puede estimarse con la varianza muestral (o cuasivarianza muestral).
En el caso del tamaño muestral para la proporción: si la proporción poblacional no es conocida, puede estimarse por la proporción muestral o considerar el caso más desfavorable (p=q=0.5)
}
\references{
Casas José M. (1997) Inferencia estadística. Editoral: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
