% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometries.R
\name{potential_geoms}
\alias{potential_geoms}
\title{Potential geometries according to the data}
\usage{
potential_geoms(data, mapping, auto = FALSE)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{mapping}{List of aesthetic mappings to use with data.}

\item{auto}{Return only one geometry.}
}
\value{
A \code{character} vector
}
\description{
Potential geometries according to the data
}
\examples{

library(ggplot2)

# One continuous variable
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length)
)

# Automatic pick a geom
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length),
  auto = TRUE
)

# One discrete variable
potential_geoms(
  data = iris,
  mapping = aes(x = Species)
)

# Two continuous variables
potential_geoms(
  data = iris,
  mapping = aes(x = Sepal.Length, y = Sepal.Width)
)
}
