% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_filters.R
\name{d_to_coef}
\alias{d_to_coef}
\title{Filter Coefficients of the Fractional Differencing Operator}
\usage{
d_to_coef(d, max_i = 1000)
}
\arguments{
\item{d}{the fractional differencing coefficient.}

\item{max_i}{the maximum index up until which to return the coefficient series.}
}
\value{
A numeric vector is returned.
}
\description{
Output is with positive signs on the left-hand side of the equation.
}
\details{
Consider the FARIMA model
\deqn{(1-B)^d Y_t = ar_1 X_{t-1} + ... + ar_p X_{t-p}+ma_1 e_{t-1}+...+ma_q e_{t-q}+e_t,}
where \eqn{e_t} are the innovations and where \eqn{X_t=(1-B)^d Y_t}.
\eqn{d} is the fractional differencing
coefficient.

The fractional differencing operator \eqn{(1-B)^d} can alternatively be expressed
as an infinite coefficient series, so that
\deqn{(1-B)^d=\sum_{l=0}^{\infty}b_l B^k,}
where \eqn{B} is the backshift operator and where \eqn{b_l}, \eqn{l=0,1,2,...},
are the coefficients. Note that \eqn{b_0=1} by definition.

The function returns the series of coefficients \eqn{\{b_l, l =0,1,2,...\}}.
}
\examples{
d_to_coef(d = 0.3, max_i = 100)

}
\author{
\itemize{
\item Dominik Schulz (Scientific Employee) (Department of Economics,
Paderborn University), \cr
Author
}
}
