% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_snr.R
\name{signal_snr}
\alias{signal_snr}
\title{Calculate signal-to-noise-ratio.}
\usage{
signal_snr(data, detrend = FALSE)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{detrend}{\code{Logical} value, optionally detrend data set before
calcualting snr.}
}
\value{
\code{Numeric} value, signal-to-noise ratio.
}
\description{
The function calculates the signal-to-noise ratio of an input signal 
vector as the ratio between mean and max.
}
\examples{

## load example data set
data(rockfall)

## calculate snr with detrend option off and on
snr <- signal_snr(data = rockfall_eseis)
print(snr$snr)

snr <- signal_snr(data = rockfall_eseis, 
                  detrend = TRUE)
print(snr$snr)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
