% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{int_lap}
\alias{int_beta}
\alias{int_gau}
\alias{int_gau_mu}
\alias{int_lap}
\alias{int_lap_mu}
\alias{int_weibull}
\title{Building Error Intervals}
\usage{
int_lap(phi, s)

int_gau(phi, s, ps = 0, threshold = 10^-2, upper = 10^6)

int_lap_mu(phi, s, ps = median(phi, na.rm = T), threshold = 10^-2,
  upper = 10^6)

int_gau_mu(phi, s, ps = mean(phi, na.rm = T), threshold = 10^-2,
  upper = 10^6)

int_beta(phi, s, ps = 10^-4, threshold = 10^-4, upper = 1,
  m1 = mean(phi, na.rm = T), m2 = mean(phi^2, na.rm = T), alpha_0 = (m1 *
  (m1 - m2))/(m2 - m1^2), beta_0 = (alpha_0 * (1 - m1)/m1))

int_weibull(phi, s, ps = 10^-4, threshold = 10^-2, upper = 10^6,
  k_0 = 1)
}
\arguments{
\item{phi}{residual values used to compute the error interval.}

\item{s}{confidence level, e,g. s=0.05 for the standard 95 percent confidence interval.}

\item{ps}{minimum value to search for solution of the integral equation to solve.
See also 'Details'.}

\item{threshold}{step size to increase ps after each iterarion. See also 'Details'.}

\item{upper}{maximum value to search for solution of the integral equation to solve.
See also 'Details'.}

\item{m1}{first moment of the residuals. Used to compute \code{alpha_0}.}

\item{m2}{second moment of the residuals. Used to compute \code{beta_0}.}

\item{alpha_0}{initial value for Newton-Raphson method for the parameter \eqn{\alpha}.
See also 'Details' and \link{multiroot}.}

\item{beta_0}{initial value for Newton-Raphson method for the parameter \eqn{\beta}.
See also 'Details' and \link{multiroot}.}

\item{k_0}{initial value for Newton-Raphson method for the parameter \eqn{\kappa}.
See also 'Details' and \link{multiroot}.}
}
\value{
Returns an object of class \code{c("error_interval","list")}
with information of the corresponding error interval.
}
\description{
\code{int_lap} computes the error interval of a set of residuals
assuming a Laplace distribution with zero location for the noise.

\code{int_gau} computes the error interval of a set of residuals
assuming a Gaussian distribution with zero mean for the noise.

\code{int_lap_mu} computes the error interval of a set of residuals
assuming a Laplace distribution.

\code{int_gau_mu} computes the error interval of a set of residuals
assuming a Gaussian distribution.

\code{int_beta} computes the error interval of a set of residuals
assuming a Beta distribution.

\code{int_weibull} computes the error interval of a set of residuals
assuming a Weibull distribution.

See also 'Details'.
}
\details{
For the Zero-\eqn{\mu} Laplace distribution the value of the corresponding integral
equation has a closed solution of the form \eqn{ps=-\sigma \log{2s}}{ps=-\sigma log2s}.

For the other distributions, starting with the initial value of \code{ps}
passed as argument, the value, \code{integral}, of the corresponding integral expression is
computed (see also 'References' for an in-depth explanation of this integral expression).
 If \code{integral} is smaller than \code{1-s} then \code{ps} is increased
by a step size of \code{threshold} value and \code{integral} is recomputed.
If \code{integral} is greater or equal than 0 or if \code{ps} gets bigger than
\code{upper}, the loop stops and the last value of \code{ps} will be its final value.

In addition, for the Beta distribution values of parameters \eqn{\alpha} and
\eqn{\beta} are estimated using Newton-Raphson method, and for the Weibull distribution
value of parameter \eqn{\kappa} is estimated using Newton-Raphson method and then estimated
value of \eqn{\lambda} is computed using a closed form that depends on \eqn{\kappa}.

See also 'References'.
}
\examples{
int_lap(rnorm(100),0.1)
int_lap(rbeta(100,0.1,0.2),0.6)


int_gau(rnorm(100),0.1)
int_gau(rnorm(100),0.1,0.1,10^-3,10^2)


int_lap_mu(rnorm(100),0.1)
int_lap_mu(rnorm(100),0.1,0.1,10^-3,10^2)


int_gau_mu(rnorm(100),0.1)
int_gau_mu(rnorm(100),0.1,0.1,10^-3,10^2)


int_beta(runif(100,0,0.99),0.1)
int_beta(runif(100,0,0.99),0.1,alpha_0=1,beta_0=1)


int_weibull(abs(rnorm(100)),0.1)
int_weibull(abs(rnorm(100)),0.1,k_0=2)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}
\seealso{
\link{error_interval}

\link{p_laplace}

\link{p_gaussian}

\link{p_beta}

\link{p_weibull}

\link{multiroot}
}

