% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idf.R
\name{read_idf}
\alias{read_idf}
\title{Read an EnergyPlus Input Data File (IDF)}
\usage{
read_idf(path, idd = NULL, encoding = "unknown")
}
\arguments{
\item{path}{Either a path, a connection, or literal data (either a single
string or a raw vector) to an EnergyPlus Input Data File (IDF). If a
file path, that file usually has a extension \code{.idf}.}

\item{idd}{Any acceptable input of \code{\link[=use_idd]{use_idd()}}. If \code{NULL}, which is the
default, the version of IDF will be passed to \code{\link[=use_idd]{use_idd()}}. If the
input is an \code{.ddy} file which does not have a version field, the
latest version of \link{Idf} cached will be used.}

\item{encoding}{The file encoding of input IDD. Should be one of \code{"unknown"},
\verb{"Latin-1" and }"UTF-8"\verb{. The default is }"unknown"` which means that
the file is encoded in the native encoding.}
}
\value{
An \link{Idf} object.
}
\description{
\code{read_idf} takes an EnergyPlus Input Data File (IDF) as input and returns an
\code{Idf} object. For more details on \code{Idf} object, please see \link{Idf} class.
}
\details{
Currently, Imf file is not fully supported. All EpMacro lines will be treated
as normal comments of the nearest downwards object. If input is an Imf file,
a warning will be given during parsing. It is recommended to convert the Imf
file to an Idf file and use \link{ParametricJob} class to conduct
parametric analysis.
}
\examples{
\dontrun{
# example model shipped with eplusr from EnergyPlus v8.8
idf_path <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr") # v8.8

# if neither EnergyPlus v8.8 nor Idd v8.8 was found, error will occur
# if EnergyPlus v8.8 is found but Idd v8.8 was not, `Energy+.idd` in EnergyPlus
# installation folder will be used for pasing
# if Idd v8.8 is found, it will be used automatically
is_avail_eplus(8.8)
is_avail_idd(8.8)

read_idf(idf_path)

# argument `idd` can be specified explicitly using `use_idd()`
read_idf(idf_path, idd = use_idd(8.8))

# you can set `download` arugment to "auto" in `use_idd()` if you want to
# automatically download corresponding IDD file when necessary
read_idf(idf_path, use_idd(8.8, download = "auto"))

# Besides use a path to an IDF file, you can also provide IDF in literal
# string format
idf_string <-
    "
    Version, 8.8;
    Building,
        Building;                !- Name
    "

read_idf(idf_string, use_idd(8.8, download = "auto"))
}
}
\seealso{
\link{Idf} class for modifying EnergyPlus model. \code{\link[=use_idd]{use_idd()}} and
\code{\link[=download_idd]{download_idd()}} for downloading and parsing EnergyPlus IDD file.
\code{\link[=use_eplus]{use_eplus()}} for configuring which version of EnergyPlus to use.
}
\author{
Hongyuan Jia
}
