% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LFMCMC.R
\name{LFMCMC}
\alias{LFMCMC}
\alias{epiworld_lfmcmc}
\alias{run_lfmcmc}
\alias{set_observed_data}
\alias{set_proposal_fun}
\alias{use_proposal_norm_reflective}
\alias{set_simulation_fun}
\alias{set_summary_fun}
\alias{set_kernel_fun}
\alias{use_kernel_fun_gaussian}
\alias{get_mean_params}
\alias{get_mean_stats}
\alias{get_initial_params}
\alias{get_current_proposed_params}
\alias{get_current_accepted_params}
\alias{get_current_proposed_stats}
\alias{get_current_accepted_stats}
\alias{get_observed_stats}
\alias{get_all_sample_params}
\alias{get_all_sample_stats}
\alias{get_all_sample_acceptance}
\alias{get_all_sample_drawn_prob}
\alias{get_all_sample_kernel_scores}
\alias{get_all_accepted_params}
\alias{get_all_accepted_stats}
\alias{get_all_accepted_kernel_scores}
\alias{get_n_samples}
\alias{get_n_stats}
\alias{get_n_params}
\alias{verbose_off.epiworld_lfmcmc}
\alias{set_params_names}
\alias{set_stats_names}
\alias{print.epiworld_lfmcmc}
\title{Likelihood-Free Markhov Chain Monte Carlo (LFMCMC)}
\usage{
LFMCMC(model = NULL)

run_lfmcmc(lfmcmc, params_init, n_samples, epsilon, seed = NULL)

set_observed_data(lfmcmc, observed_data)

set_proposal_fun(lfmcmc, fun)

use_proposal_norm_reflective(lfmcmc)

set_simulation_fun(lfmcmc, fun)

set_summary_fun(lfmcmc, fun)

set_kernel_fun(lfmcmc, fun)

use_kernel_fun_gaussian(lfmcmc)

get_mean_params(lfmcmc)

get_mean_stats(lfmcmc)

get_initial_params(lfmcmc)

get_current_proposed_params(lfmcmc)

get_current_accepted_params(lfmcmc)

get_current_proposed_stats(lfmcmc)

get_current_accepted_stats(lfmcmc)

get_observed_stats(lfmcmc)

get_all_sample_params(lfmcmc)

get_all_sample_stats(lfmcmc)

get_all_sample_acceptance(lfmcmc)

get_all_sample_drawn_prob(lfmcmc)

get_all_sample_kernel_scores(lfmcmc)

get_all_accepted_params(lfmcmc)

get_all_accepted_stats(lfmcmc)

get_all_accepted_kernel_scores(lfmcmc)

get_n_samples(lfmcmc)

get_n_stats(lfmcmc)

get_n_params(lfmcmc)

\method{verbose_off}{epiworld_lfmcmc}(x)

set_params_names(lfmcmc, names)

set_stats_names(lfmcmc, names)

\method{print}{epiworld_lfmcmc}(x, burnin = 0, ...)
}
\arguments{
\item{model}{A model of class \link{epiworld_model} or \code{NULL} (see details).}

\item{lfmcmc}{LFMCMC model}

\item{params_init}{Initial model parameters, treated as double}

\item{n_samples}{Number of samples, treated as integer}

\item{epsilon}{Epsilon parameter, treated as double}

\item{seed}{Random engine seed}

\item{observed_data}{Observed data, treated as double.}

\item{fun}{A function (see details).}

\item{x}{LFMCMC model to print}

\item{names}{Character vector of names.}

\item{burnin}{Integer. Number of samples to discard as burnin before
computing the summary.}

\item{...}{Ignored}
}
\value{
The \code{LFMCMC} function returns a model of class \link{epiworld_lfmcmc}.

The simulated model of class \link{epiworld_lfmcmc}.

\itemize{
\item \code{use_kernel_fun_gaussian}: The LFMCMC model with kernel function set to
gaussian.
}

\itemize{
\item \code{get_mean_params}: The param means for the given lfmcmc model.
}

\itemize{
\item \code{get_mean_stats}: The stats means for the given lfmcmc model.
}

\itemize{
\item The function \code{get_initial_params} returns the initial parameters
for the given LFMCMC model.
}

\itemize{
\item The function \code{get_current_proposed_params} returns the proposed parameters
for the next LFMCMC sample.
}

\itemize{
\item The function \code{get_current_accepted_params} returns the most recently accepted
parameters (the current state of the LFMCMC)
}

\itemize{
\item The function \code{get_current_proposed_stats} returns the statistics
from the simulation run with the proposed parameters
}

\itemize{
\item The function \code{get_current_accepted_stats} returns the statistics
from the most recently accepted parameters
}

\itemize{
\item The function \code{get_observed_stats} returns the statistics
for the observed data
}

\itemize{
\item The function \code{get_all_sample_params} returns a matrix of sample
parameters for the given LFMCMC model. with the number of rows equal to the
number of samples and the number of columns equal to the number of
parameters.
}

\itemize{
\item The function \code{get_all_sample_stats} returns a matrix of statistics
for the given LFMCMC model. with the number of rows equal to the number of
samples and the number of columns equal to the number of statistics.
}

\itemize{
\item The function \code{get_all_sample_acceptance} returns a vector of boolean flags
which indicate whether a given sample was accepted
}

\itemize{
\item The function \code{get_all_sample_drawn_prob} returns a vector of drawn probabilities
for each sample
}

\itemize{
\item The function \code{get_all_sample_kernel_scores} returns a vector of kernel scores for
each sample
}

\itemize{
\item The function \code{get_all_accepted_params} returns a matrix of accepted
parameters for the given LFMCMC model. with the number of rows equal to the
number of samples and the number of columns equal to the number of
parameters.
}

\itemize{
\item The function \code{get_all_accepted_stats} returns a matrix of accepted statistics
for the given LFMCMC model. with the number of rows equal to the number of
samples and the number of columns equal to the number of statistics.
}

\itemize{
\item The function \code{get_all_accepted_kernel_scores} returns a vector of kernel scores for
each accepted sample
}

\itemize{
\item The functions \code{get_n_samples}, \code{get_n_stats}, and \code{get_n_params}
return the number of samples, statistics, and parameters for the given
LFMCMC model, respectively.
}

\itemize{
\item The \code{verbose_on} and \code{verbose_off} functions return the same model, however
\code{verbose_off} returns the model with no progress bar.
}

\itemize{
\item \code{set_params_names}: The lfmcmc model with the parameter names added.
}

\itemize{
\item \code{set_stats_names}: The lfmcmc model with the stats names added.
}
}
\description{
Likelihood-Free Markhov Chain Monte Carlo (LFMCMC)
}
\details{
Performs a Likelihood-Free Markhov Chain Monte Carlo simulation. When
\code{model} is not \code{NULL}, the model uses the same random-number generator
engine as the model. Otherwise, when \code{model} is \code{NULL}, a new random-number
generator engine is created.

The functions passed to the LFMCMC object have different arguments depending
on the object:
\itemize{
\item \code{set_proposal_fun}: A vector of parameters and the model.
\item \code{set_simulation_fun}: A vector of parameters and the model.
\item \code{set_summary_fun}: A vector of simulated data and the model.
\item \code{set_kernel_fun}: A vector of simulated statistics, observed statistics,
epsilon, and the model.
}

The \code{verbose_on} and \code{verbose_off} functions activate and deactivate printing
progress on screen, respectively. Both functions return the model (\code{x}) invisibly.
}
\examples{
## Setup an SIR model to use in the simulation
model_seed <- 122
model_sir <- ModelSIR(name = "COVID-19", prevalence = .1,
  transmission_rate = .9, recovery_rate = .3)
agents_smallworld(
  model_sir,
  n = 1000,
  k = 5,
  d = FALSE,
  p = 0.01
)
verbose_off(model_sir)
run(model_sir, ndays = 50, seed = model_seed)

## Setup LFMCMC
# Extract the observed data from the model
obs_data <- get_today_total(model_sir)

# Define the simulation function
simfun <- function(params, lfmcmc_obj) {
  set_param(model_sir, "Recovery rate", params[1])
  set_param(model_sir, "Transmission rate", params[2])
  run(model_sir, ndays = 50)
  res <- get_today_total(model_sir)
  return(res)
}

# Define the summary function
sumfun <- function(dat, lfmcmc_obj) {
  return(dat)
}

# Create the LFMCMC model
lfmcmc_model <- LFMCMC(model_sir) |>
  set_simulation_fun(simfun) |>
  set_summary_fun(sumfun) |>
  use_proposal_norm_reflective() |>
  use_kernel_fun_gaussian() |>
  set_observed_data(obs_data)

## Run LFMCMC simulation
# Set initial parameters
par0 <- c(0.1, 0.5)
n_samp <- 2000
epsil <- 1.0

# Run the LFMCMC simulation
verbose_off(lfmcmc_model)
run_lfmcmc(
  lfmcmc = lfmcmc_model,
  params_init = par0,
  n_samples = n_samp,
  epsilon = epsil,
  seed = model_seed
)

# Print the results
set_stats_names(lfmcmc_model, get_states(model_sir))
set_params_names(lfmcmc_model, c("Immune recovery", "Infectiousness"))

print(lfmcmc_model)

get_mean_stats(lfmcmc_model)
get_mean_params(lfmcmc_model)

}
