% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-history}
\alias{epiworld-history}
\alias{get_hist_total}
\alias{epiworld_hist_total}
\alias{get_today_total}
\alias{plot.epiworld_hist}
\alias{get_hist_virus}
\alias{epiworld_hist_virus}
\alias{get_hist_tool}
\alias{epiworld_hist_tool}
\title{Model history and totals}
\usage{
get_hist_total(x)

get_today_total(x)

\method{plot}{epiworld_hist}(x, y, ...)

get_hist_virus(x)

get_hist_tool(x)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model).}

\item{y}{Ignored.}

\item{...}{In the case of plot methods, further arguments passed to
\link[graphics:plot.default]{graphics::plot}.}
}
\value{
\itemize{
\item The \code{get_hist_total} function returns an object of class
\link{epiworld_hist_total}.
}

\itemize{
\item The \code{get_today_total} function returns a named vector with the
total number of individuals in each state at the end of the simulation.
}

\itemize{
\item The \code{get_hist_virus} function returns an object of class
\link{epiworld_hist_virus}.
}

\itemize{
\item The \code{get_hist_tool} function returns an object of \link{epiworld_hist_tool}.
}
}
\description{
Functions to extract simulation history at total, variant, and tool levels,
plus snapshot totals and a common plot method for history objects.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

# Running the simulation for 50 steps (days)
set.seed(937)
run(seirconn, 50)

# Retrieving date, state, and counts dataframe including any added tools
get_hist_tool(seirconn)

# Retrieving overall date, state, and counts dataframe
head(get_hist_total(seirconn))

# Retrieving date, state, and counts dataframe by variant
head(get_hist_virus(seirconn))

# Snapshot of totals at end of simulation
get_today_total(seirconn)

}
\concept{History}
\concept{model-utility-functions}
