% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviz.R
\name{create_topwords}
\alias{create_topwords}
\title{Plot the top words report on the epitweetr dashboard}
\usage{
create_topwords(
  topic,
  country_codes = c(),
  date_min = "1900-01-01",
  date_max = "2100-01-01",
  with_retweets = FALSE,
  location_type = "tweet",
  top = 25
)
}
\arguments{
\item{topic}{Character(1) containing the topic to use for the report}

\item{country_codes}{Character vector containing the ISO 3166-1 alpha-2 countries to plot, default: c()}

\item{date_min}{Date indicating start of the reporting period, default: "1900-01-01"}

\item{date_max}{Date indicating end of the reporting period, default: "2100-01-01"}

\item{with_retweets}{Logical value indicating whether to include retweets in the time series, default: FALSE}

\item{location_type}{Character(1) this parameter is currently being IGNORED since this report shows only tweet location and cannot showed user or both locations for performance reasons, default: 'tweet'}

\item{top}{numeric(1) Parameter indicating the number of words to show, default: 25}
}
\value{
A named list containing two elements: 'chart' with the ggplot2 figure and 'data' containing the dataframe that was used to build the map.
}
\description{
Generates a bar plot of most popular words in tweets, for one topic
}
\details{
Produces a bar chat showing the occurrences of the most popular words in the collected tweets based on the provided parameters.
For performance reasons on the \code{\link{aggregate_tweets}} function, this report only shows tweet location and ignores the location_type parameter

This report may be empty for combinations of countries and topics with very few tweets since for performance reasons, the calculation of top words is an approximation using chunks of 10.000 tweets.

This functions requires that \code{\link{search_loop}} and \code{\link{detect_loop}} have already been run successfully to show results.
}
\examples{
if(FALSE){
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   #Getting topword chart for dengue for France, Chile, Australia for last 30 days
   create_topwords(
     topic = "dengue", 
     country_codes = c("FR", "CL", "AU"),
     date_min = as.Date(Sys.time())-30, 
     date_max=as.Date(Sys.time())
   ) 
 }
}
\seealso{
\code{\link{trend_line}}
 \code{\link{create_map}}
 \code{\link{aggregate_tweets}}
 \code{\link{geotag_tweets}}
 \code{\link{detect_loop}}
 \code{\link{search_loop}}
}
