% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounders.R
\name{confounders}
\alias{confounders}
\title{Sensitivity analysis to correct for unknown or unmeasured confounding without
effect modification}
\usage{
confounders(
  case,
  exposed,
  type = c("RR", "OR", "RD"),
  bias_parms = NULL,
  alpha = 0.05
)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{type}{Choice of implementation, with no effect measure modification for
ratio measures (relative risk -- RR; odds ratio -- OR) or difference measures
(risk difference -- RD).}

\item{bias_parms}{Numeric vector defining the 3 necessary bias parameters. This
vector has 3 elements, in the following order:
\enumerate{
\item the association between the confounder and the outcome among those who were not exposed (RR, OR, or RD according to choice of implementation),
\item the prevalence of the confounder among the exposed (between 0 and 1), and
\item the prevalence of the confounder among the unexposed (between 0 and 1).
}}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{cfder.data}{The same table for Confounder +.}
\item{nocfder.data}{The same table for Confounder -.}
\item{obs.measures}{A table of relative risk with confidence intervals; for
Total, Confounder +, and Confounder -.}
\item{adj.measures}{A table of Standardized Morbidity Ratio and Mantel-Haenszel
estimates.}
\item{bias.parms}{Input bias parameters.}
}
\description{
Simple sensitivity analysis to correct for unknown or unmeasured confounding
without effect modification. Implementation for ratio measures (relative risk
-- RR, or odds ratio -- OR) and difference measures (risk difference -- RD).
}
\details{
The analytic approach uses the "relative risk due to confounding" as defined by
Miettinen (1972), i.e. \eqn{RR_adj = \frac{RR_crude}{RR_conf}} where RR_adj is the
standardized (adjusted) risk ratio, RR_crude is the crude risk ratio, and RR_conf
is the relative risk component attributable to confounding by the stratification
factors. The output provides both RR_adj (SMR or Mantel-Haenszel) and the RR_conf.
}
\examples{
# The data for this example come from:
# Tyndall M.W., Ronald A.R., Agoki E., Malisa W., Bwayo J.J., Ndinya-Achola J.O.
# et al.
# Increased risk of infection with human immunodeficiency virus type 1 among
# uncircumcised men presenting with genital ulcer disease in Kenya.
# Clin Infect Dis 1996;23:449-53.
confounders(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "RR",
bias_parms = c(.63, .8, .05))

confounders(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "OR",
bias_parms = c(.63, .8, .05))

confounders(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "RD",
bias_parms = c(-.37, .8, .05))
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.59--78, Springer.

Miettinen, 1971. Components of the Crude Risk Ratio. \emph{Am J Epidemiol}
96(2):168-172.
}
