% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{epiparameter_distribution_functions}
\alias{epiparameter_distribution_functions}
\alias{density.epiparameter}
\alias{cdf.epiparameter}
\alias{quantile.epiparameter}
\alias{generate.epiparameter}
\title{PDF, CDF, PMF, quantiles and random number generation for \verb{<epiparameter>}
objects}
\usage{
\method{density}{epiparameter}(x, at, ...)

\method{cdf}{epiparameter}(x, q, ..., log = FALSE)

\method{quantile}{epiparameter}(x, p, ...)

\method{generate}{epiparameter}(x, times, ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}

\item{at}{The quantiles to evaluate at.}

\item{...}{\link{dots} Extra arguments to be passed to the method.}

\item{q}{The quantiles to evaluate at.}

\item{log}{If \code{TRUE}, probabilities will be given as log probabilities.}

\item{p}{The probabilities to evaluate at.}

\item{times}{The number of random samples.}
}
\value{
\code{numeric} vector.
}
\description{
The \verb{<epiparameter>} object holds a probability distribution
which can either be a continuous or discrete distribution. These are the
density, cumulative distribution, quantile and random number generation
functions. These operate on any distribution that can be included in an
\verb{<epiparameter>} object.
}
\examples{
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 1, scale = 1)
  )
)

# example of each distribution method for an `epiparameter` object
stats::density(ep, at = 1)
distributional::cdf(ep, q = 1)
stats::quantile(ep, p = 0.2)
distributional::generate(ep, times = 10)
}
\keyword{epiparameter_distribution_functions}
