% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getAddOffset}
\alias{getAddOffset}
\title{Retrieve additive offset.}
\usage{
getAddOffset(pop)
}
\arguments{
\item{pop}{A valid \code{Population} object with additive effects
attached}
}
\value{
The additive offset is returned.
}
\description{
Retrieve offset used for calculating additive component.
}
\details{
In order for the initial population to have an additive
component with a mean of 0 for its phenotype, an offset is added,
and it remains fixed across generations. This function retrieves
that offset.
}
\examples{
# Construct a new population with additive effects
pop <- Population(
  popSize = 20, map = map100snp, QTL = 20,
  broadH2 = 0.4, narrowh2 = 0.4, traitVar = 40,
  alleleFrequencies = runif(100, 0.05, 0.5)
)
pop <- addEffects(pop)

# Find the additive contribution to the individuals' phenotypes
hap <- getHaplo(pop)
hap <- (hap[[1]] + hap[[2]])[, getQTL(pop)$Index]
(hap \%*\% getAddCoefs(pop))[, 1] + getAddOffset(pop)

# Compare with additive component from getComponents()
getComponents(pop)$Additive
}
\seealso{
\code{\link{getAddCoefs}}, \code{\link{addEffects}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
