% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.epifit.R
\name{AIC.epifit}
\alias{AIC.epifit}
\title{Function for calculating Akaike's \sQuote{An Information Criterion} (AIC) from epifit object.}
\usage{
\method{AIC}{epifit}(object, ..., k = 2)
}
\arguments{
\item{object}{a fitted epifit object.}

\item{...}{not used in this version, only for compatibility purpose with generic function \code{AIC} currently.}

\item{k}{numeric, the \emph{penalty} per parameter to be used; the default \code{k = 2} is the classical AIC.}
}
\value{
a numeric AIC value.
}
\description{
Function called from generic function AIC in \pkg{stats} when the argument is epifit object.
}
\examples{
library(survival)
# The simplest test data set from coxph function
test1 <- list(time=c(4,3,1,1,2,2,3),
              status=c(1,1,1,0,1,1,0),
              x=c(0,2,1,1,1,0,0),
              sex=c(0,0,0,0,1,1,1))
AIC(coxph(Surv(time,status)~x + strata(sex), data=test1))
modeleq <- "cox(time,status)/strata(sex)~exp(beta*x)"
AIC(epifit(modeleq=modeleq, data=test1))
}
\seealso{
\code{\link[stats]{AIC}}.
}

