% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydraulics.r
\name{ENinitH}
\alias{ENinitH}
\title{Initialize hydraulic engine}
\usage{
ENinitH(flag)
}
\arguments{
\item{flag}{A two-digit flag indicating if hydraulic results will be saved to the
hydraulics file (rightmost digit) and if link flows should be re-initialized.}
}
\value{
Returns NULL invisibly; called for side effect
}
\description{
\code{ENinitH} Initializes storage tank levels, link status and settings, and the simulation clock 
  time prior to running a hydraulic analysis.
}
\details{
Call \code{ENinitH} prior to running a hydraulic analysis using \code{ENrunH} and
  \code{ENnextH}.\code{ENopenH} must have been called prior to calling \code{ENinitH}. Do not call 
  \code{ENinitH} if a complete hydraulic analysis is being made with a call to \code{ENsolveH}.
  Values of flag have the following meanings:
  
  \tabular{ll}{
   00   \tab  do not re-initialize flows, do not save results to file\cr
   01   \tab  do not re-initialize flows, save results to file\cr
   10   \tab  re-initialize flows, do not save results to file\cr
   11   \tab  re-initialize flows, save results to file
   } 
  
   Set \code{flag} to 1 (or 11) if you will be making a subsequent water quality run, using 
   \code{ENreport} to generate a report, or using \code{ENsavehydfile} to save the binary 
   hydraulics file.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENopenH()
ENinitH(0)
ENrunH()
ENcloseH()
ENclose()
# clean-up the created files
file.remove("Net1.rpt") 
}
\seealso{
\code{ENopenH}, \code{ENrunH}, \code{ENnextH}, \code{ENcloseH}
}
