% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.r
\name{ENgetnodetype}
\alias{ENgetnodetype}
\title{Retrieve the node-type code}
\usage{
ENgetnodetype(nodeindex)
}
\arguments{
\item{nodeindex}{An integer specifying the node index.}
}
\value{
integer type-code of the node.
}
\description{
\code{ENgetnodetype} retrieves the node-type code
}
\note{
Node indexes are consecutive integers starting from 1. 

  Node type codes consist of the following constants:

  \tabular{lll}{
  \code{EN_JUNCTION}  \tab 0 \tab Junction node\cr
  \code{EN_RESERVOIR} \tab 1 \tab Reservoir node\cr
  \code{EN_TANK}      \tab 2 \tab Tank node
  }
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetnodetype(1)
ENgetnodetype(10)
ENgetnodetype(11)
ENclose()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___network_info.html}
}
