% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_perturb.R
\name{plot_perturb}
\alias{plot_perturb}
\title{Visualizations for a simulated ecological niche after iteratively perturbing the observation coordinates}
\usage{
plot_perturb(
  input,
  predict = TRUE,
  mean_cols = c("#8B3A3A", "#CCCCCC", "#0000CD"),
  var_cols = c("#E5E5E5", "#1A1A1A"),
  cov_labs = c("V1", "V2"),
  cref0 = "EPSG:4326",
  cref1 = NULL,
  lower_lrr = NULL,
  upper_lrr = NULL,
  upper_sd = NULL,
  digits = 1,
  ...
)
}
\arguments{
\item{input}{An object of class 'list' from the \code{\link{perlrren}} function.}

\item{predict}{Logical. If TRUE (the default), will visualize the four summary statistics in geographic space. If FALSE, will not.}

\item{mean_cols}{Character string of length three (3) specifying the colors for plots with a divergent color palette: 1) presence, 2) neither, and 3) absence. The default colors in hex are \code{c("#8B3A3A", "#CCCCCC", "#0000CD")} or \code{c("indianred4", "grey80", "blue3")}.}

\item{var_cols}{Character string of length two (2) specifying the colors for plots with a sequential color palette from low to high values. The default colors in hex are \code{c("#E5E5E5", "#1A1A1A")} or \code{c("grey90", "grey10")}.}

\item{cov_labs}{Character string of length two (2) specifying the x- and y-axis labels in plots of the ecological niche in covariate space. The default values are generic \code{c("V1", "V2")}.}

\item{cref0}{Character. The Coordinate Reference System (CRS) for the x- and y-coordinates in geographic space. The default is WGS84 \code{"EPSG:4326"}.}

\item{cref1}{Optional, character. The Coordinate Reference System (CRS) to spatially project the x- and y-coordinates in geographic space.}

\item{lower_lrr}{Optional, numeric. Lower cut-off value for the log relative risk value in the color key (typically a negative value). The default is no limit and the color key will include the minimum value of the log relative risk surface.}

\item{upper_lrr}{Optional, numeric. Upper cut-off value for the log relative risk value in the color key (typically a positive value). The default is no limit and the color key will include the maximum value of the log relative risk surface.}

\item{upper_sd}{Optional, numeric. Upper cut-off value for the standard deviation of log relative risk value in the color key. The default is no limit and the color key will include the maximum value of the standard deviation surface.}

\item{digits}{Optional, integer. The number of significant digits for the color key labels using the \code{\link[base]{round}} function (default is 1).}

\item{...}{Arguments passed to \code{\link[fields]{image.plot}} for additional graphical features.}
}
\value{
This function produces four plots in a two-dimensional space where the axes are the two specified covariates: 1) mean of the log relative risk, 2) standard deviation of the log relative risk, 3) mean of the asymptotically normal p-value, and 4) proportion of iterations were statistically significant based on a two-tailed alpha-level threshold. If \code{predict = TRUE}, this function produces an additional four plots of the summary statistics above in a two-dimensional geographic space where the axes are longitude and latitude.
}
\description{
Create multiple plots of output from the \code{\link{perlrren}} function, specifically for the four summary statistics in covariate space and geographic space.
}
\examples{
if (interactive()) {
  set.seed(1234) # for reproducibility

# Using the 'bei' and 'bei.extra' data within {spatstat.data}

# Covariate data (centered and scaled)
  ims <- spatstat.data::bei.extra
  ims[[1]]$v <- scale(ims[[1]]$v)
  ims[[2]]$v <- scale(ims[[2]]$v)
  
# Presence data
  presence <- spatstat.data::bei
  spatstat.geom::marks(presence) <- data.frame("presence" = rep(1, presence$n),
                                              "lon" = presence$x,
                                              "lat" = presence$y)
                                          
# (Pseudo-)Absence data
  absence <- spatstat.random::rpoispp(0.008, win = ims[[1]])
  spatstat.geom::marks(absence) <- data.frame("presence" = rep(0, absence$n),
                                              "lon" = absence$x,
                                              "lat" = absence$y)
# Combine into readable format
  obs_locs <- spatstat.geom::superimpose(presence, absence, check = FALSE)
  spatstat.geom::marks(obs_locs)$id <- seq(1, obs_locs$n, 1)
  spatstat.geom::marks(obs_locs) <- spatstat.geom::marks(obs_locs)[ , c(4, 2, 3, 1)]
 
# Specify categories for varying degrees of spatial uncertainty
## Creates three groups
  spatstat.geom::marks(obs_locs)$levels <- as.factor(stats::rpois(obs_locs$n,
                                                                  lambda = 0.05))
                                                                  
# Run perlrren
  test_perlrren <- perlrren(obs_ppp = obs_locs,
                            covariates = ims,
                            radii = c(10, 100, 500),
                            n_sim = 10)
                            
# Run plot_perturb                             
  plot_perturb(input = test_perlrren)
}

}
