#' @title Hydrometer readings for a clay loam
#' 
#' @description
#' Data obtained with an 152H hydrometer in accordance with ASTM D422-63(2007)e2.
#' 
#' @format
#' A data frame containing 7 rows and 4 columns with information on:
#' \tabular{ll}{
#' Time: \tab the measurement time in minutes\cr
#' Temperature: \tab the temperature of the soil suspension\cr
#' Reading: \tab the hydrometer reading at the bottom of the meniscus\cr
#' Blank: \tab a blank value obtained in 5 g/L sodium
#' hexametaphosphate solution (composite correction)\cr
#' }
#' 
#' @references
#' ASTM D422-63(2007)e2, 2007. Standard Test Method for Particle-Size Analysis
#' of Soils (Technical standard). ASTM International, West Conshohocken, PA.
#' Available from \url{http://www.astm.org/Standards/D422.htm}
#' 
#' @seealso 
#' \code{\link{texture}}
#' 
#' @docType data
#' @keywords data
#' @name clayloam
NULL
