% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.lm.R
\name{get_simulate_function.lm}
\alias{get_simulate_function.lm}
\title{Function to compute/extract a simulate function for response
vectors from an object of class \code{lm}/\code{enriched_lm}}
\usage{
\method{get_simulate_function}{lm}(object, ...)
}
\arguments{
\item{object}{an object of class \code{lm} or\code{enriched_lm}}

\item{...}{currently not used}
}
\description{
Function to compute/extract a simulate function for response
vectors from an object of class \code{lm}/\code{enriched_lm}
}
\details{
The computed/extracted simulate function has arguments
\describe{

\item{coefficients}{the regression coefficients at which the
response vectors are simulated. If missing then the maximum
likelihood estimates are used}

\item{dispersion}{the dispersion parameter at which the response
vectors are simulated. If missing then the maximum likelihood
estimate is used}

\item{nsim}{number of response vectors to simulate.  Defaults to \code{1}}

\item{seed}{an object specifying if and how the random number
generator should be initialized ('seeded'). It can be either
\code{NULL} or an integer that will be used in a call to
\code{set.seed} before simulating the response vectors.  If set,
the value is saved as the \code{seed} attribute of the returned
value.  The default, \code{NULL} will not change the random
generator state, and return \code{.Random.seed} as the \code{seed}
attribute, see \code{Value}}

}
}
