% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.family.R
\name{enrich.family}
\alias{enrich.family}
\title{Enrich objects of class \code{\link{family}}}
\usage{
\method{enrich}{family}(object, with = "all", ...)
}
\arguments{
\item{object}{an object of class \code{\link{family}}}

\item{with}{a character vector with enrichment options for \code{object}}

\item{...}{extra arguments to be passed to the \code{compute_*}
functions}
}
\value{
The object \code{object} of class \code{\link{family}} with
    extra components. \code{get_enrichment_options.family()}
    returns the components and their descriptions.
}
\description{
Enrich objects of class \code{\link{family}} with family-specific
mathematical functions
}
\details{
\code{\link{family}} objects specify the details of the models used
by functions such as \code{\link[stats]{glm}}. The families
implemented in the \code{stats} package include
\code{\link[stats]{binomial}}, \code{\link[stats]{gaussian}},
\code{\link[stats]{Gamma}}, \code{\link[stats]{inverse.gaussian}},
and \code{\link[stats]{poisson}}. \code{\link[stats]{family}}
objects specify particular characteristics of distributions from
the exponential family. Such distributions have probability mass or
density function of the form \deqn{f(y; \theta, \phi) =
\exp\left\{\frac{y\theta - b(\theta) - c_1(y)}{\phi/m} -
\frac{1}{2}a\left(-\frac{m}{\phi}\right) + c_2(y)\right\} \quad y
\in Y \subset \Re\,, \theta \in \Theta \subset \Re\, , \phi >
0}{f(y, theta, phi) = exp((y * theta - b(theta) - c_1(y))/(phi/m) -
a(-m/phi)/2 - c_2(y))} where \eqn{m > 0}{m > 0} is an observation
weight, and \eqn{a(.)}{a(.)}, \eqn{b(.)}{b(.)},
\eqn{c_1(.)}{c_1(.)} and \eqn{c_2(.)}{c_2(.)} are sufficiently
smooth, real-valued functions.

The expected value and the variance of such distributions is
\eqn{\mu = b'(\theta)}{mu = b'(theta)} and \eqn{\phi V(\mu)/m}{phi * V(mu)/m},
respectively, where \eqn{V(\mu)}{V(mu)} is called the variance
function. The parameter \eqn{\phi}{phi} is called a dispersion
parameter.

Characteristics of the exponential family that are already
implemented in \code{\link[stats]{family}} objects include:

\itemize{

\item \code{variance}: \eqn{V(.)}{V(.)}

\item \code{dev.resids}: \eqn{-2\left\{y c_1'(\mu) - y c_1'(y) -
b(c_1'(\mu)) + b(c'_1(y))\right\}}{-2(y c_1'(mu) - y c_1'(y) -
b(c'(mu)) + b(c'(y)))}

\item \code{aic}: \eqn{-2\sum_{i = 1}^n \left\{\log f(y_i; \theta,
\phi)\right\} + 2\delta}{-2*sum(log f(y, theta, phi)) + 2*delta}
where \eqn{\delta}{delta} is \code{1} if the family has a dispersion
parameter and \code{0} else
}

The \code{\link{quasi}} families differ from the other families in
that the variance function is not determined by the family but may
be supplied by the user. Also, the \code{\link{quasibinomial}} and
\code{\link{quasipoisson}} families differ from the
\code{\link{binomial}} and \code{\link{poisson}} families only in
that the dipsersion parameter is estimated to account for
overdispersion.

For \code{\link[stats]{quasi}}, \code{dev.resid} is \eqn{m(y -
\mu)^2}{m*(y - mu)^2} . For \code{\link[stats]{quasibinomial}} and
\code{\link[stats]{quasipoisson}}, \code{dev.resid} is the same as
for \code{\link[stats]{quasibinomial}} and
\code{\link{quasipoisson}}, respectively.  The \code{aic} is
\code{NA} for all \code{quasi} families. See
\code{\link[stats]{quasi}} for more details.

The \code{enrich} method can enrich \code{\link{family}} family
objects with extra characteristics of the family and of the chosen
link function. See \code{\link{enrich.link-glm}} for the enrichment
of \code{\link[=make.link]{link-glm}} objects.
}
\examples{

## An example from ?glm to illustrate that things still work with
## enriched families
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm(counts ~ outcome + treatment, family = enrich(poisson()))
anova(glm.D93)
summary(glm.D93)
}
