% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.enspls.R
\name{print.enspls.fit}
\alias{print.enspls.fit}
\title{Print Fitted Ensemble Sparse Partial Least Squares Object}
\usage{
\method{print}{enspls.fit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{enspls.fit}.}

\item{...}{Additional parameters for \code{\link{print}}.}
}
\description{
Print coefficients of each model in the enspls.fit object.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
fit = enspls.fit(x, y, reptimes = 5, maxcomp = 3,
                 alpha = c(0.3, 0.6, 0.9))
print(fit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.fit}} for fitting ensemble sparse
partial least squares regression models.
}

