% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.fit.R
\name{enspls.fit}
\alias{enspls.fit}
\title{Ensemble Sparse Partial Least Squares Regression}
\usage{
enspls.fit(x, y, maxcomp = 5L, alpha = seq(0.2, 0.8, 0.2), MCtimes = 500L,
  method = c("mc", "bootstrap"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{maxcomp}{Maximum number of components included within the models,
if not specified, default is 5.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{MCtimes}{times of Monte-Carlo}

\item{method}{\code{"mc"} or \code{"bootstrap"}. Default is \code{"mc"}.}

\item{ratio}{sample ratio used when \code{method = "mc"}}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing all sparse partial least squares model objects.
}
\description{
Ensemble sparse partial least squares regression.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
fit = enspls.fit(x, y, MCtimes = 4, maxcomp = 3)
print(fit)
predict(fit, newx = x)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.fs}} for feature selection with ensemble
sparse partial least squares regression.
See \code{\link{enspls.od}} for outlier detection with ensemble
sparse partial least squares regression.
}

