% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelSize.r
\name{modelSize}
\alias{modelSize}
\title{Number of response data in a model object}
\usage{
modelSize(x, binary = TRUE, graceful = TRUE)
}
\arguments{
\item{x}{A model object. This can be of many classes, including "gbm", "glm", "gam", "MaxEnt", and so on.}

\item{binary}{If \code{TRUE} (default) then the number of 1s and 0s in the response data is returned. If \code{FALSE} then the returned values is the total number of response data.}

\item{graceful}{If \code{TRUE} (default), then the function returns \code{NA} if the function cannot determine the sample size from the model object. If \code{FALSE}, then the function exits with an error.}
}
\value{
One or two named integers.
}
\description{
This function returns the number of response data used in a model (i.e., the sample size). If the data are binary it can return the number of 1s and 0s.
}
\examples{

set.seed(123)
y <- runif(1:101)^2
yBinary <- as.integer(y > 0.6)
x <- data.frame(x1=1:101, x2=rnorm(101))
model <- lm(y ~ x1 + x2, data=x)
modelBinary <- glm(yBinary ~ x1 + x2, data=x, family='binomial')
modelSize(model, FALSE)
modelSize(model, TRUE) # not binary input... notice warning
modelSize(modelBinary)
modelSize(modelBinary, FALSE)

}
