% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emusegs.R
\name{write.emusegs}
\alias{write.emusegs}
\title{Write an Emu segment list to a file}
\usage{
write.emusegs(seglist, file)
}
\arguments{
\item{seglist}{An Emu segment list}

\item{file}{The name of a file to write the segment list into.}
}
\value{
None.
}
\description{
Writes an Emu segment list to a file
}
\section{Side Effects}{
 The segment list is written to a file in the
standard format, suitable for input to \code{gettrack} or other Emu utility
programs.
}

\examples{

   data(dip)
   #dip a segment list - first 10 segments only
   dip[1:10,]
   \dontrun{write.emusegs(dip, "write.emusegs.example.txt")}
   
   #The file write.emusegs.example.txt would have been written to R_HOME
   \dontrun{unlink("write.emusegs.example.txt")}

}
\seealso{
\code{\link{query}}
}
\keyword{misc}
