% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.files.R
\name{import_mediaFiles}
\alias{import_mediaFiles}
\title{Import media files to emuDB}
\usage{
import_mediaFiles(emuDBhandle, dir, targetSessionName = "0000",
  verbose = TRUE)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{dir}{directory containing mediafiles or session directories}

\item{targetSessionName}{name of session in which to create the new bundles}

\item{verbose}{display infos & show progress bar}
}
\description{
Import new recordings (media files) to emuDB and create bundles.
Looks for files with the defined mediafile extension of the emuDB 
(see \code{mediaFileExtension} in vignette \code{emuDB}) in \code{dir}
or in sub-directories thereof (interpreted as sessions), for each mediafile
create a bundle directory
named as the basename of the mediafile in the specified session, and copies 
the mediafile into the bundle. If not already present, adds 'OSCI' and 
'SPEC' perspectives to the emuDB config file.
}
\examples{
\dontrun{
## Add mediafiles from directory

 import_mediaFiles(myEmuDB,dir="/data/mymedia/")

}
}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
