% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC-support.R
\name{hpd.summary}
\alias{hpd.summary}
\title{Summarize an emmGrid from a Bayesian model}
\usage{
hpd.summary(object, prob, by, type, point.est = median, ...)
}
\arguments{
\item{object}{an \code{emmGrid} object having a non-missing \code{post.beta} slot}

\item{prob}{numeric probability content for HPD intervals (note: when not specified,
the current \code{level} option is used; see \code{\link{emm_options}})}

\item{by}{factors to use as \code{by} variables}

\item{type}{prediction type as in \code{\link{summary.emmGrid}}}

\item{point.est}{function to use to compute the point estimates from the 
posterior sample for each grid point}

\item{...}{required but not used}
}
\value{
an object of class \code{summary_emm}
}
\description{
This function computes point estimates and HPD intervals for each
factor combination in \code{object@emmGrid}. While this function
may be called independently, it is called utomatically by the S3 method
\code{\link{summary.emmGrid}} when the object is based on a Bayesian model.
(Note: the \code{level} argument, or its default, is passed as \code{prob}).
}
\examples{
load(system.file("extdata", "cbpp.RData", package = "emmeans"))
cbpp.rg <- do.call(emmobj, cbpp.list)
hpd.summary(emmeans(cbpp.rg, "period"))

}
