% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm-example.R
\name{emm_example}
\alias{emm_example}
\title{Run or list additional examples}
\usage{
emm_example(name, run = !list, list = FALSE, ...)
}
\arguments{
\item{name}{Character name of file to run. We look for a file with this name
(with \code{".R"} appended) in the system files provided with \pkg{emmeans}.}

\item{run}{Logical choosing whether or not to run the example code}

\item{list}{Logical choosing whether or not to list the example code}

\item{...}{Used only by the developer}
}
\description{
This function exists so as to provide cleaner-looking examples in
help files when it must be run conditionally on another package.
Typically we want to run the code (\code{run = TRUE} is the default),
or otherwise just list it on the console (\code{list = TRUE}).
}
\examples{
# List an example
emm_example("qdrg-biglm", list = TRUE)

# Run an example
if (require(biglm))
    emm_example("qdrg-biglm")

}
