% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_plot}
\alias{compare_plot}
\title{Shows plots for the comparison of direct and model-based estimates}
\usage{
compare_plot(
  direct,
  model,
  indicator = "all",
  label = "orig",
  color = c("blue", "lightblue3"),
  shape = c(16, 16),
  line_type = c("solid", "solid"),
  gg_theme = NULL
)
}
\arguments{
\item{direct}{an object of type "emdi","direct", representing point and MSE
estimates.}

\item{model}{an object of type "emdi","model", representing point and MSE
estimates.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean", "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", 
"Poverty_Gap", "Gini", "Quintile_Share" or the function name/s of 
"custom_indicator/s"; (iii) groups of indicators: "Quantiles", "Poverty", 
"Inequality" or "Custom".If two of these groups are selected, only the first
one is returned. Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (see also \code{\link{ebp}}) 
and do not appear in groups of indicators even though these might belong to 
one of the groups.}

\item{label}{argument that enables to customize title and axis labels. There 
are three options to label the evaluation plots: (i) original labels ("orig"), 
(ii) axis labels but no title ("no_title"), (iii) neither axis 
labels nor title ("blank").}

\item{color}{a vector with two elements. The first color determines
the color of the line in the scatter plot and the color for the direct 
estimates in the line plot. The second color specifies the color of the line
for the model-based estimates.}

\item{shape}{a numeric vector with two elements. The first shape determines
the shape of the points in the line plot for the direct estimates and the 
second shape for the model-based estimates. The options are numbered from 
0 to 25.}

\item{line_type}{a character vector with two elements. The first line type 
determines the type of the line for the direct estimates and the 
second type for the model-based estimates. The options are: "twodash", 
"solid", "longdash", "dotted", "dotdash", "dashed" and "blank".}

\item{gg_theme}{\code{\link[ggplot2]{theme}} list from package \pkg{ggplot2}.
For using this argument, package \pkg{ggplot2} must be loaded via 
\code{library(ggplot2)}. See also Example 2.}
}
\value{
A scatter plot and a line plot comparing direct and model-based 
estimators for each selected indicator obtained by \code{\link[ggplot2]{ggplot}}.
}
\description{
For all indicators or a selection of indicators two plots are returned. The 
first plot is a scatter plot of the direct and model-based point estimates 
and the second is a line plot with both point estimates.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")
  
# Generation of two emdi objects
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
threshold = function(y){0.6 * median(y)}, L = 50, MSE = TRUE,
na.rm = TRUE, cpus = 1)

emdi_direct <- direct(y = "eqIncome", smp_data = eusilcA_smp,
smp_domains = "district", weights = "weight", threshold = 11161.44,
var = TRUE, boot_type = "naive", B = 50, seed = 123, na.rm = TRUE)

# Example 1: Receive first overview
compare_plot(direct = emdi_direct, model = emdi_model)

# Example 2: Change plot theme
library(ggplot2)
compare_plot(emdi_direct, emdi_model, indicator = "Median",
gg_theme = theme(axis.line = element_line(size = 3, colour = "grey80"),
plot.background = element_rect(fill = "lightblue3"),
legend.position = "none"))
}
}
\seealso{
\code{\link{emdiObject}}, \code{\link{direct}}, \code{\link{ebp}}
}
