% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emBayes.R
\name{emBayes}
\alias{emBayes}
\title{fit a model with given tuning parameters}
\usage{
emBayes(y, clin = NULL, X, quant, s0, s1, func, error = 0.01, maxiter = 200)
}
\arguments{
\item{y}{a vector of response variable.}

\item{clin}{a matrix of clinical factors. It has default value NULL.}

\item{X}{a matrix of genetic factors.}

\item{quant}{value of quantile.}

\item{s0}{value of the spike scale \eqn{s_{0}}.}

\item{s1}{value of the slab scale \eqn{s_{1}}.}

\item{func}{methods to perform variable selection. Two choices are available: "ssLASSO" and "ssQLASSO".}

\item{error}{cutoff value for determining convergence. The algorithm reaches convergence if the difference in the expected log-likelihood of two iterations is less than the value of error. The default value is 0.01.}

\item{maxiter}{the maximum number of iterations that is used in the estimation algorithm. The default value is 200.}
}
\value{
A list with components:
\item{alpha}{a vector containing the estimated intercept and clinical coefficients.}
\item{intercept}{value of the estimated intercept.}
\item{clin.coe}{a vector of estimated clinical coefficients.}
\item{beta}{a vector of estimated beta coefficients.}
\item{sigma}{value of estimated asymmetric Laplace distribution scale parameter \eqn{\sigma}.}
\item{theta}{value of estimated probability parameter \eqn{\theta}.}
\item{iter}{value of number of iterations.}
\item{ll}{a vector of expectation of likelihood at each iteration.}
}
\description{
This function performs penalized variable selection based on spike-and-slab quantile LASSO (ssQLASSO) or spike-and-slab LASSO (ssLASSO).
Typical usage is to first obtain the optimal spike scale and slab scale using cross-validation, then specify them in the 'emBayes' function.
}
\details{
The current version of emBayes supports two types of methods: "ssLASSO" and "ssQLASSO".
\itemize{
\item \strong{ssLASSO:} spike-and-slab LASSO fits a Bayesian linear regression through the EM algorithm.  
\item \strong{ssQLASSO:} spike-and-slab quantile LASSO fits a Bayesian quantile regression (based on asymmetric Laplace distribution) through the EM algorithm.
}
Users can choose the desired method by setting {func="ssLASSO" or "ssQLASSO"}.
}
\examples{
data(data)
##load the clinical factors, genetic factors, response and quantile data
clin=data$clin
X=data$X
y=data$y
quant=data$quant

##generate tuning vectors of desired range 
t0 <- seq(0.01,0.015,length.out=2)
t1 <- seq(0.1,0.5,length.out=2)

##perform cross-validation and obtain tuning parameters based on check loss
CV <- cv.emBayes(y,clin,X,quant,t0,t1,k=5,func="ssQLASSO",error=0.01,maxiter=200)
s0 <- CV$CL.s0
s1 <- CV$CL.s1

##perform BQLSS under optimal tuning and calculate value of TP and FP for selecting beta 
EM <- emBayes(y,clin,X,quant,s0,s1,func="ssQLASSO",error=0.01,maxiter=200)
fit <- EM$beta
coef <- data$coef
tp <- sum(fit[coef!=0]!=0)
fp <- sum(fit[coef==0]!=0)
list(tp=tp,fp=fp)

}
