% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{clustering_validation}
\alias{clustering_validation}
\title{Create a table containing three validation metrics for clustering: Purity, F-measure
and Rand Index (RI)}
\usage{
clustering_validation(true_labels, clusters)
}
\arguments{
\item{true_labels}{Atomic vector with the true labels of the data.}

\item{clusters}{The clusters predicted by the clustering method.}
}
\value{
A \code{table} containing values for Purity, F-measure and RI.
}
\description{
Create a table containing three validation metrics for clustering: Purity, F-measure
and Rand Index (RI)
}
\examples{
set.seed(1221)
vars1 <- c("dtaEI", "dtaMEI")
data <- ehymet::sim_model_ex1()
true_labels <- c(rep(1, 50), rep(2, 50))
data_ind <- generate_indices(data)
clus_kmeans <- ehymet::clustInd_kmeans(data_ind, list(vars1))
cluskmeans_mahalanobis_dtaEIdtaMEI <- clus_kmeans$kmeans_mahalanobis_dtaEIdtaMEI$cluster
clustering_validation(true_labels, cluskmeans_mahalanobis_dtaEIdtaMEI)

}
