% Generated by roxygen2 (4.0.1): do not edit by hand
\name{setDefaults2}
\alias{setDefaults2}
\title{Set default values for the two-sample (ZI)PoGa model formulation}
\usage{
setDefaults2(priors.mu, priors.phi, priors.delta, priors.psiB, priors.psiA,
  priors.deltaPsi)
}
\arguments{
\item{priors.mu}{named list with hyperprior specifications for \eqn{\mu}{mu},
containing elements \code{hyperpars} and \code{proposalDist}}

\item{priors.phi}{named list with hyperprior specifications for the overdispersion parameter \eqn{\phi}{phi},
containing elements \code{hyperpars}, \code{proposalDist} (unif or gamma) and
in the case of a uniform proposal also a tuning parameter \code{v}}

\item{priors.delta}{named list with hyperprior specifications for the reduction in mean \eqn{\delta}{delta},
containing elements \code{hyperpars} and \code{proposalDist}}

\item{priors.psiB}{named list with hyperprior specifications for the prevalence \eqn{\psi_B}{psi.B} before treatment,
containing elements \code{hyperpars}}

\item{priors.psiA}{named list with hyperprior specifications for the prevalence \eqn{\psi_A}{psi.A} after treatment,
containing elements \code{hyperpars}}

\item{priors.deltaPsi}{named list with hyperprior specifications for the reduction in prevalence \eqn{\delta_\psi}{delta_psi},
containing elements \code{hyperpars} and \code{proposalDist}}
}
\value{
A named list with prior specifications for \eqn{\mu}{mu}, \eqn{\phi}{phi}, \eqn{\delta}{delta} and
   \eqn{\psi_B}{psi.B}, \eqn{\psi_A}{psi.A}.
   Default prior distributions are:
   \item{mu}{gamma[1, 0.001]}
   \item{phi}{gamma[1, 0.1]}
   \item{delta}{gamma[1, 1]}
   \item{psiB}{beta[1, 1]}
   \item{psiA}{beta[1, 1]}
   \item{deltaPsi}{beta[1, 1]}
  Default proposal distributions for \eqn{\mu}{mu}, \eqn{\phi}{phi} and
      \eqn{\delta}{delta} (in the unpaired situation) are:
   \item{mu}{approximating inverse gamma, gamma or log-normal distribution}
   \item{phi}{unif[max(current.value - v,0), current.value + v], with \eqn{v=0.5}}
   \item{delta}{approximating inverse gamma, gamma or log-normal distribution}
}
\description{
Set default values for the two-sample (ZI)PoGa model formulation
}
\keyword{internal}

