% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_language.R
\name{p_superiority}
\alias{p_superiority}
\alias{cles}
\alias{cohens_u1}
\alias{cohens_u2}
\alias{cohens_u3}
\alias{p_overlap}
\alias{vd_a}
\alias{wmw_odds}
\title{Cohen's \emph{U}s and Other Common Language Effect Sizes (CLES)}
\usage{
p_superiority(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  paired = FALSE,
  parametric = TRUE,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)

cohens_u1(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  parametric = TRUE,
  ci = 0.95,
  alternative = "two.sided",
  iterations = 200,
  verbose = TRUE,
  ...
)

cohens_u2(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  parametric = TRUE,
  ci = 0.95,
  alternative = "two.sided",
  iterations = 200,
  verbose = TRUE,
  ...
)

cohens_u3(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  parametric = TRUE,
  ci = 0.95,
  alternative = "two.sided",
  iterations = 200,
  verbose = TRUE,
  ...
)

p_overlap(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  parametric = TRUE,
  ci = 0.95,
  alternative = "two.sided",
  iterations = 200,
  verbose = TRUE,
  ...
)

vd_a(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)

wmw_odds(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  paired = FALSE,
  ci = 0.95,
  alternative = "two.sided",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x, y}{A numeric vector, or a character name of one in \code{data}.
Any missing values (\code{NA}s) are dropped from the resulting vector.
\code{x} can also be a formula (see \code{\link[stats:t.test]{stats::t.test()}}), in which case \code{y} is
ignored.}

\item{data}{An optional data frame containing the variables.}

\item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}.}

\item{parametric}{Use parametric estimation (see \code{\link[=cohens_d]{cohens_d()}}) or
non-parametric estimation (see \code{\link[=rank_biserial]{rank_biserial()}}). See details.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods. When \code{x} is a formula,
these can be \code{subset} and \code{na.action}.}

\item{iterations}{The number of bootstrap replicates for computing confidence
intervals. Only applies when \code{ci} is not \code{NULL} and \code{parametric = FALSE}.}
}
\value{
A data frame containing the common language effect sizes (and
optionally their CIs).
}
\description{
Cohen's \eqn{U_1}, \eqn{U_2}, and \eqn{U_3}, probability of superiority,
proportion of overlap, Wilcoxon-Mann-Whitney odds, and Vargha and Delaney's
\emph{A} are CLESs. These are effect sizes that represent differences between two
(independent) distributions in probabilistic terms (See details). Pair with
any reported \code{\link[stats:t.test]{stats::t.test()}} or \code{\link[stats:wilcox.test]{stats::wilcox.test()}}.
}
\details{
These measures of effect size present group differences in probabilistic
terms:
\itemize{
\item \strong{Probability of superiority} is the probability that, when sampling an
observation from each of the groups at random, that the observation from
the second group will be larger than the sample from the first group. For
the one-sample (or paired) case, it is the probability that the sample (or
difference) is larger than \emph{mu}. (Vargha and Delaney's \emph{A} is an alias for
the non-parametric \emph{probability of superiority}.)
\item \strong{Cohen's \eqn{U_1}} is the proportion of the total of both distributions
that does not overlap.
\item \strong{Cohen's \eqn{U_2}} is the proportion of one of the groups that exceeds
\emph{the same proportion} in the other group.
\item \strong{Cohen's \eqn{U_3}} is the proportion of the second group that is smaller
than the median of the first group.
\item \strong{Overlap} (OVL) is the proportional overlap between the distributions.
(When \code{parametric = FALSE}, \code{\link[bayestestR:overlap]{bayestestR::overlap()}} is used.)
}

Wilcoxon-Mann-Whitney odds are the \emph{odds} of
non-parametric superiority (via \code{\link[=probs_to_odds]{probs_to_odds()}}), that is the odds that,
when sampling an observation from each of the groups at random, that the
observation from the second group will be larger than the sample from the
first group.

Where \eqn{U_1}, \eqn{U_2}, and \emph{Overlap} are agnostic to the direction of
the difference between the groups, \eqn{U_3} and probability of superiority
are not.

The parametric version of these effects assumes normality of both populations
and homoscedasticity. If those are not met, the non parametric versions
should be used.
}
\note{
If \code{mu} is not 0, the effect size represents the difference between the
first \emph{shifted sample} (by \code{mu}) and the second sample.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
For parametric CLES, the CIs are transformed CIs for Cohen's \emph{d} (see
\code{\link[=d_to_u3]{d_to_u3()}}). For non-parametric (\code{parametric = FALSE}) CLES, the CI of
\emph{Pr(superiority)} is a transformed CI of the rank-biserial correlation
(\code{\link[=rb_to_p_superiority]{rb_to_p_superiority()}}), while for all others, confidence intervals are
estimated using the bootstrap method (using the \code{{boot}} package).
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Bootstrapped CIs}{
Some effect sizes are directionless--they do have a minimum value that would
be interpreted as "no effect", but they cannot cross it. For example, a null
value of \link[=kendalls_w]{Kendall's W} is 0, indicating no difference between
groups, but it can never have a negative value. Same goes for
\link[=cohens_u2]{U2} and \link[=p_overlap]{Overlap}: the null value of \eqn{U_2} is
0.5, but it can never be smaller than 0.5; am \emph{Overlap} of 1 means "full
overlap" (no difference), but it cannot be larger than 1.
\cr\cr
When bootstrapping CIs for such effect sizes, the bounds of the CIs will
never cross (and often will never cover) the null. Therefore, these CIs
should not be used for statistical inference.
}

\examples{
cohens_u2(mpg ~ am, data = mtcars)

p_superiority(mpg ~ am, data = mtcars, parametric = FALSE)

wmw_odds(mpg ~ am, data = mtcars)

x <- c(1.83, 0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3)
y <- c(0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29)

p_overlap(x, y)
p_overlap(y, x) # direction of effect does not matter

cohens_u3(x, y)
cohens_u3(y, x) # direction of effect does matter

}
\references{
\itemize{
\item Cohen, J. (1977). Statistical power analysis for the behavioral sciences.
New York: Routledge.
\item Reiser, B., & Faraggi, D. (1999). Confidence intervals for the overlapping
coefficient: the normal equal variance case. Journal of the Royal Statistical
Society, 48(3), 413-418.
\item Ruscio, J. (2008). A probability-based measure of effect size: robustness
to base rates and other factors. Psychological methods, 13(1), 19–30.
\item Vargha, A., & Delaney, H. D. (2000). A critique and improvement of the CL
common language effect size statistics of McGraw and Wong. Journal of
Educational and Behavioral Statistics, 25(2), 101-132.
\item O’Brien, R. G., & Castelloe, J. (2006, March). Exploiting the link between
the Wilcoxon-Mann-Whitney test and a simple odds statistic.
In Proceedings of the Thirty-first Annual SAS Users Group International
Conference (pp. 209-31). Cary, NC: SAS Institute.
\item Agresti, A. (1980). Generalized odds ratios for ordinal data.
Biometrics, 59-67.
}
}
\seealso{
\code{\link[=sd_pooled]{sd_pooled()}}

Other standardized differences: 
\code{\link{cohens_d}()},
\code{\link{mahalanobis_d}()},
\code{\link{rank_biserial}()}

Other rank-based effect sizes: 
\code{\link{rank_biserial}()},
\code{\link{rank_epsilon_squared}()}
}
\concept{rank-based effect sizes}
\concept{standardized differences}
