% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_info.R
\name{standardize_info}
\alias{standardize_info}
\title{Get Standardization Information}
\usage{
standardize_info(model, robust = FALSE, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{robust}{Logical, if \code{TRUE}, centering is done by substracting the
median from the variables and dividing it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by substracting the
mean and dividing it by the standard deviation (SD).}

\item{...}{Arguments passed to or from other methods.}
}
\description{
This function extracts information, such as the deviations (SD or MAD) from parent variables, that are necessary for post-hoc standardization of parameters. This function gives a window on how standardized are obtained, i.e., by what they are devided. The "basic" method of standardization uses
}
\examples{
model <- lm(Sepal.Width ~ Sepal.Length * Species, data = iris)
}
