% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale.R
\name{ale}
\alias{ale}
\alias{ale.default}
\alias{ale.ranger}
\alias{ale.explainer}
\alias{ale.H2OModel}
\title{Accumulated Local Effects (ALE)}
\usage{
ale(object, ...)

\method{ale}{default}(
  object,
  v,
  data,
  pred_fun = stats::predict,
  trafo = NULL,
  which_pred = NULL,
  w = NULL,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  ale_n = 50000L,
  ale_bin_size = 200L,
  seed = NULL,
  ...
)

\method{ale}{ranger}(
  object,
  v,
  data,
  pred_fun = NULL,
  trafo = NULL,
  which_pred = NULL,
  w = NULL,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  ale_n = 50000L,
  ale_bin_size = 200L,
  seed = NULL,
  ...
)

\method{ale}{explainer}(
  object,
  v = colnames(data),
  data = object$data,
  pred_fun = object$predict_function,
  trafo = NULL,
  which_pred = NULL,
  w = object$weights,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  ale_n = 50000L,
  ale_bin_size = 200L,
  seed = NULL,
  ...
)

\method{ale}{H2OModel}(
  object,
  data,
  v = object@parameters$x,
  pred_fun = NULL,
  trafo = NULL,
  which_pred = NULL,
  w = object@parameters$weights_column$column_name,
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 13L,
  outlier_iqr = 2,
  ale_n = 50000L,
  ale_bin_size = 200L,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted model.}

\item{...}{Further arguments passed to \code{pred_fun()}, e.g., \code{type = "response"} in
a \code{glm()} or (typically) \code{prob = TRUE} in classification models.}

\item{v}{Variable names to calculate statistics for.}

\item{data}{Matrix or data.frame.}

\item{pred_fun}{Prediction function, by default \code{stats::predict}.
The function takes three arguments (names irrelevant): \code{object}, \code{data}, and \code{...}.}

\item{trafo}{How should predictions be transformed?
A function or \code{NULL} (default). Examples are \code{log} (to switch to link scale)
or \code{exp} (to switch from link scale to the original scale).
Applied after \code{which_pred}.}

\item{which_pred}{If the predictions are multivariate: which column to pick
(integer or column name). By default \code{NULL} (picks last column). Applied before
\code{trafo}.}

\item{w}{Optional vector with case weights. Can also be a column name in \code{data}.
Having observations with non-positive weight is equivalent to excluding them.}

\item{breaks}{An integer, vector, or "Sturges" (the default) used to determine
bin breaks of continuous features. Values outside the total bin range are placed
in the outmost bins. To allow varying values of \code{breaks} across features,
\code{breaks} can be a list of the same length as \code{v}, or a \emph{named} list with breaks
for certain variables.}

\item{right}{Should bins be right-closed? The default is \code{TRUE}.
Vectorized over \code{v}. Only relevant for continuous features.}

\item{discrete_m}{Numeric features with up to this number of unique values are
treated as discrete and are therefore dropped from the calculations.}

\item{outlier_iqr}{If \code{breaks} is an integer or "Sturges", the breaks of a continuous
feature are calculated without taking into account feature values outside
quartiles +- \code{outlier_iqr} * IQR (where <= 9997 values are used to calculate the
quartiles). To let the breaks cover the full data range, set \code{outlier_iqr} to
0 or \code{Inf}. Vectorized over \code{v}.}

\item{ale_n}{Size of the data used for calculating ALE.
The default is 50000. For larger \code{data} (and \code{w}), \code{ale_n} rows are randomly
sampled. Each variable specified by \code{v} uses the same sample.
Set to 0 to omit ALE calculations.}

\item{ale_bin_size}{Maximal number of observations used per bin for ALE calculations.
If there are more observations in a bin, \code{ale_bin_size} indices are
randomly sampled. The default is 200. Applied after sampling regarding \code{ale_n}.}

\item{seed}{Optional integer random seed used for:
\itemize{
\item \emph{ALE:} select background data if \code{n > ale_n}, and for bins > \code{ale_bin_size}.
\item \emph{Calculating breaks:} The bin range is determined without values outside
quartiles +- 2 IQR using a sample of <= 9997 observations to calculate quartiles.
}}
}
\value{
A list (of class "EffectData") with a data.frame per feature having columns:
\itemize{
\item \code{bin_mid}: Bin mid points. In the plots, the bars are centered around these.
\item \code{bin_width}: Absolute width of the bin. In the plots, these equal the bar widths.
\item \code{bin_mean}: For continuous features, the (possibly weighted) average feature
value within bin. For discrete features equivalent to \code{bin_mid}.
\item \code{N}: The number of observations within bin.
\item \code{weight}: The weight sum within bin. When \code{w = NULL}, equivalent to \code{N}.
\item Different statistics, depending on the function call.
}

Use single bracket subsetting to select part of the output. Note that each
data.frame contains an attribute "discrete" with the information whether the
feature is discrete or continuous. This attribute might be lost when you manually
modify the data.frames.
}
\description{
Calculates ALE for one or multiple continuous features specified by \code{X}.

The concept of ALE was introduced in Apley et al. (2020) as an alternative to
partial dependence (PD). The Ceteris Paribus clause behind PD is a blessing and
a curse at the same time:
\itemize{
\item Blessing: The interpretation is easy and similar to what we know from linear
regression  (just averaging out interaction effects).
\item Curse: The model is applied to very unlikely or even impossible feature
combinations, especially with strongly dependent features.
}

ALE fixes the curse as follows: Per bin, the local effect is calculated as the
partial dependence difference between lower and upper bin break, using only
observations falling into this bin. This is repeated for all bins,
and the values are \emph{accumulated}.

ALE values are plotted against right bin breaks.
}
\details{
The function is a convenience wrapper around \code{\link[=feature_effects]{feature_effects()}}, which calls
the barebone implementation \code{\link[=.ale]{.ale()}} to calculate ALE.
}
\section{Methods (by class)}{
\itemize{
\item \code{ale(default)}: Default method.

\item \code{ale(ranger)}: Method for ranger models.

\item \code{ale(explainer)}: Method for DALEX explainers

\item \code{ale(H2OModel)}: Method for H2O models

}}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
M <- ale(fit, v = "Petal.Length", data = iris)
M |> plot()

M2 <- ale(fit, v = colnames(iris)[-1], data = iris, breaks = 5)
plot(M2, share_y = "all")  # Only continuous variables shown
}
\references{
Apley, Daniel W., and Jingyu Zhu. 2020. \emph{Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models.}
Journal of the Royal Statistical Society Series B: Statistical Methodology,
82 (4): 1059–1086. doi:10.1111/rssb.12377.
}
\seealso{
\code{\link[=feature_effects]{feature_effects()}}, \code{\link[=.ale]{.ale()}}
}
