% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{ComparePlot}
\alias{ComparePlot}
\title{A plot function to compare different eefAnalytics S3 objects from the eefAnalytics package.}
\usage{
ComparePlot(
  eefAnalyticsList,
  group = NULL,
  Conditional = TRUE,
  ES_Total = TRUE,
  modelNames = NULL
)
}
\arguments{
\item{eefAnalyticsList}{A list of eefAnalytics S3 objects from eefAnalytics package.}

\item{group}{a scalar value indicating which intervention to plot.
This must not be greater than the number of intervention groups excluding the control group.
For a two arm trial, the maximum value is 1 and a maximum value of 2 for three arm trial.}

\item{Conditional}{a logical value to indicate whether to plot conditional effect size.
The default is Conditional=TRUE, otherwise Conditional=FALSE should be specified for plot based on unconditional effect size.
 Conditional variance is total or residual variance a multilevel model with fixed effects, whilst unconditional variance is total variance or residual variance from a multilevel model with only intercept as fixed effect.}

\item{ES_Total}{A logical value indicating whether to plot the effect size based on total variance or within school variance.
The default is ES_Total=TRUE, to plot effect size using total variance.
ES_Total=FALSE should be specified for effect size based on within school or residuals variance.}

\item{modelNames}{a string factor containing the names of model to compare. See examples below.}
}
\value{
Returns a bar plot to compare the different methods.
}
\description{
It generates bar plot that compares the effect size from eefAnalytics' methods.
}
\details{
\code{ComparePlot} produces a bar plot which compares the effect sizes and the associated confidence intervals from the different models.
For a multilevel model, it shows the effect size based on residual variance and total variance.
}
\examples{
if(interactive()){

data(mstData)
###############
##### SRT #####
###############

outputSRT <- srtFREQ(Posttest~ Intervention + Prettest,
                     intervention = "Intervention", data = mstData)

outputSRTBoot <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nBoot=1000, data = mstData)

###############
##### MST #####
###############

outputMST <- mstFREQ(Posttest~ Intervention + Prettest,
                     random = "School", intervention = "Intervention", data = mstData)

outputMSTBoot <- mstFREQ(Posttest~ Intervention + Prettest,
                         random = "School", intervention = "Intervention",
                         nBoot = 1000, data = mstData)

##################
##### Bayesian #####
##################

outputSRTbayes <- srtBayes(Posttest~ Intervention + Prettest,
                           intervention = "Intervention",
                           nSim = 2000, data = mstData)

## comparing different results

ComparePlot(list(outputSRT,outputSRTBoot,outputMST,outputMSTBoot,outputSRTbayes),
            modelNames =c("ols", "olsBoot","MLM","MLMBoot","OLSBayes"),group=1)


}
}
