% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram.R
\name{aec_add_carto_f}
\alias{aec_add_carto_f}
\title{aec_add_carto_f - computes and binds the cartogram coordinates to original data}
\usage{
aec_add_carto_f(nat_data)
}
\arguments{
\item{nat_data}{subset of data with centroids of electoral divisions}
}
\description{
Add the cartogram locations as new variables to original data
and make any of these that were not made equal to the original centroids.
This is simply all of the Australian electoral cartogram steps in one hit.
}
\examples{
library(eechidna)
library(dplyr)
library(ggplot2)

nat_map16 <- nat_map_download(2016)
nat_data16 <- nat_data_download(2016)

nat_data16 <- nat_data16 \%>\% select(-c(x,y)) # remove existing cartogram coordinates
nat_data_cart <- aec_add_carto_f(nat_data16)
# Map theme
library(ggthemes)

ggplot(data=nat_data_cart, aes(map_id=id)) +
  geom_map(map = nat_map16, fill="grey90", colour="white") +
    geom_point(aes(x=x, y=y), size=2, alpha=0.4,
                 colour="#572d2c", inherit.aes=FALSE) +
    expand_limits(x=nat_map16$long, y=nat_map16$lat) +
    theme_map() + coord_equal()

}
