% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm-ls-data.R
\docType{data}
\name{items_spm_ls}
\alias{items_spm_ls}
\title{Last Series of the Standard Progressive Matrices (SPM-LS) Item Responses}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 499 rows and 12 columns.
}
\usage{
items_spm_ls
}
\description{
Last Series of the Standard Progressive Matrices (SPM-LS) Item Responses
}
\details{
Items with the correct answer response based off of Table 9 of the
Robitzsch (2020) pre-print paper.
\itemize{
\item SPM1: \strong{7}
\item SPM2: \strong{6}
\item SPM3: \strong{8}
\item SPM4: \strong{2}
\item SPM5: \strong{1}
\item SPM6: \strong{5}
\item SPM7: \strong{1}
\item SPM8: \strong{6}
\item SPM9: \strong{3}
\item SPM10: \strong{2}
\item SPM11: \strong{4}
\item SPM12: \strong{5}
}
}
\section{Answer coding}{

The subjects answered a set of assessment items seeking to determine
the level of matrix reasoning. Answers given in \strong{bold} represent the desired
response. If a subject matched this response, they were given a 1 inside
of the item matrix, otherwise they received a zero.
}

\references{
\strong{Assessment Design:}
\itemize{
\item Raven, J. C. (1941). Standardization of progressive matrices, 1938.
\emph{British Journal of Medical Psychology}, \emph{19}(1), 137–150.
\doi{10.1111/j.2044-8341.1941.tb00316.x}
}

\strong{Data originated from:}
\itemize{
\item Myszkowski, N., & Storme, M. (2018). A snapshot of g? Binary and
polytomous item-response theory investigations of the last series of the
standard progressive matrices (spm-ls). \emph{Intelligence}, \emph{68}, 109–116.
\doi{10.1016/j.intell.2018.03.010}
\item Robitzsch, A. (2020). Regularized latent class analysis for polytomous
item responses: An application to spm-ls data. \emph{Preprint}.
\doi{10.20944/preprints202007.0269.v1}
}

\strong{Data used in:}
\itemize{
\item TBA
}
}
\keyword{datasets}
